/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.security;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AllPermission;
import java.util.Hashtable;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.PathableClassLoader;
import org.apache.commons.logging.PathableTestSuite;
import org.apache.commons.logging.security.MockSecurityManager;

public class SecurityAllowedTestCase
extends TestCase {
    private SecurityManager oldSecMgr;

    public static Test suite() throws Exception {
        PathableClassLoader parent = new PathableClassLoader(null);
        parent.useExplicitLoader("junit.", Test.class.getClassLoader());
        parent.addLogicalLib("commons-logging");
        parent.addLogicalLib("testclasses");
        parent.addLogicalLib("commons-lang3");
        Class<?> testClass = parent.loadClass("org.apache.commons.logging.security.SecurityAllowedTestCase");
        return new PathableTestSuite(testClass, parent);
    }

    public void setUp() {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21)) {
            return;
        }
        this.oldSecMgr = System.getSecurityManager();
    }

    public void tearDown() {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21)) {
            return;
        }
        System.setSecurityManager(this.oldSecMgr);
    }

    public void testAllAllowed() {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21)) {
            return;
        }
        System.setProperty("org.apache.commons.logging.LogFactory.HashtableImpl", CustomHashtable.class.getName());
        MockSecurityManager mySecurityManager = new MockSecurityManager();
        mySecurityManager.addPermission(new AllPermission());
        System.setSecurityManager(mySecurityManager);
        try {
            Class<?> c = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.apache.commons.logging.LogFactory");
            Method m = c.getMethod("getLog", Class.class);
            Log log = (Log)m.invoke(null, ((Object)((Object)this)).getClass());
            int untrustedCodeCount = mySecurityManager.getUntrustedCodeCount();
            log.info((Object)"testing");
            System.setSecurityManager(null);
            Field factoryField = c.getDeclaredField("factories");
            factoryField.setAccessible(true);
            Object factoryTable = factoryField.get(null);
            SecurityAllowedTestCase.assertNotNull((Object)factoryTable);
            SecurityAllowedTestCase.assertEquals((String)CustomHashtable.class.getName(), (String)factoryTable.getClass().getName());
            SecurityAllowedTestCase.assertEquals((String)"Untrusted code count", (int)untrustedCodeCount, (int)mySecurityManager.getUntrustedCodeCount());
        }
        catch (Throwable t) {
            System.setSecurityManager(this.oldSecMgr);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            SecurityAllowedTestCase.fail((String)("Unexpected exception:" + t.getMessage() + ":" + sw.toString()));
        }
    }

    public static class CustomHashtable<K, V>
    extends Hashtable<K, V> {
        private static final long serialVersionUID = 8941017300059246720L;
    }
}

