/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.pool2.DestroyMode;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.Waiter;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.commons.pool2.impl.PooledTestObject;
import org.apache.commons.pool2.impl.TestConstants;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestAbandonedKeyedObjectPool {
    private GenericKeyedObjectPool<Integer, PooledTestObject> pool;
    private AbandonedConfig abandonedConfig;

    @BeforeEach
    public void setUp() {
        this.abandonedConfig = new AbandonedConfig();
        this.abandonedConfig.setRemoveAbandonedTimeout(TestConstants.ONE_SECOND_DURATION);
        Assertions.assertEquals((Object)TestConstants.ONE_SECOND_DURATION, (Object)this.abandonedConfig.getRemoveAbandonedTimeoutDuration());
        Assertions.assertEquals((int)1, (int)this.abandonedConfig.getRemoveAbandonedTimeout());
        this.abandonedConfig.setRemoveAbandonedTimeout(1);
        Assertions.assertEquals((Object)TestConstants.ONE_SECOND_DURATION, (Object)this.abandonedConfig.getRemoveAbandonedTimeoutDuration());
        Assertions.assertEquals((int)1, (int)this.abandonedConfig.getRemoveAbandonedTimeout());
        this.pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SimpleFactory(), new GenericKeyedObjectPoolConfig(), this.abandonedConfig);
    }

    @AfterEach
    public void tearDown() throws Exception {
        ObjectName jmxName = this.pool.getJmxName();
        String poolName = Objects.toString(jmxName, null);
        this.pool.clear();
        this.pool.close();
        this.pool = null;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> result = mbs.queryNames(new ObjectName("org.apache.commoms.pool2:type=GenericKeyedObjectPool,*"), null);
        int registeredPoolCount = result.size();
        StringBuilder msg = new StringBuilder("Current pool is: ");
        msg.append(poolName);
        msg.append("  Still open pools are: ");
        for (ObjectName name : result) {
            msg.append(name.toString());
            msg.append(" created via\n");
            msg.append(mbs.getAttribute(name, "CreationStackTrace"));
            msg.append('\n');
            mbs.unregisterMBean(name);
        }
        Assertions.assertEquals((int)0, (int)registeredPoolCount, (String)msg.toString());
    }

    @Test
    public void testAbandonedInvalidate() throws Exception {
        this.abandonedConfig = new AbandonedConfig();
        this.abandonedConfig.setRemoveAbandonedOnMaintenance(true);
        this.abandonedConfig.setRemoveAbandonedTimeout(Duration.ofMillis(2000L));
        this.pool.close();
        this.pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SimpleFactory(100L, 0L), new GenericKeyedObjectPoolConfig(), this.abandonedConfig);
        int n = 10;
        this.pool.setMaxTotal(10);
        this.pool.setBlockWhenExhausted(false);
        this.pool.setDurationBetweenEvictionRuns(Duration.ofMillis(250L));
        PooledTestObject pooledObj = null;
        Integer key = 0;
        for (int i = 0; i < 5; ++i) {
            pooledObj = (PooledTestObject)this.pool.borrowObject((Object)key);
        }
        Thread.sleep(1000L);
        if (!this.pool.getKeys().contains(key)) {
            Thread.sleep(1000L);
        }
        if (!this.pool.getKeys().contains(key)) {
            Thread.sleep(1000L);
        }
        this.pool.invalidateObject((Object)key, (Object)pooledObj);
        Thread.sleep(2000L);
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
        Assertions.assertEquals((long)5L, (long)this.pool.getDestroyedCount());
    }

    @Test
    public void testAbandonedReturn() throws Exception {
        this.abandonedConfig = new AbandonedConfig();
        this.abandonedConfig.setRemoveAbandonedOnBorrow(true);
        this.abandonedConfig.setRemoveAbandonedTimeout(TestConstants.ONE_SECOND_DURATION);
        this.pool.close();
        this.pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SimpleFactory(200L, 0L), new GenericKeyedObjectPoolConfig(), this.abandonedConfig);
        int n = 10;
        this.pool.setMaxTotal(10);
        this.pool.setBlockWhenExhausted(false);
        PooledTestObject obj = null;
        for (int i = 0; i < 8; ++i) {
            obj = (PooledTestObject)this.pool.borrowObject((Object)0);
        }
        Objects.requireNonNull(obj, "Unable to borrow object from pool");
        int deadMansHash = obj.hashCode();
        ConcurrentReturner returner = new ConcurrentReturner(obj);
        Thread.sleep(2000L);
        returner.start();
        Assertions.assertTrue((((PooledTestObject)this.pool.borrowObject((Object)0)).hashCode() != deadMansHash ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)this.pool.getNumIdle());
        Assertions.assertEquals((int)1, (int)this.pool.getNumActive());
    }

    @Test
    public void testConcurrentInvalidation() throws Exception {
        int i;
        int POOL_SIZE = 30;
        this.pool.setMaxTotalPerKey(30);
        this.pool.setMaxIdlePerKey(30);
        this.pool.setBlockWhenExhausted(false);
        ArrayList<PooledTestObject> vec = new ArrayList<PooledTestObject>();
        for (int i2 = 0; i2 < 30; ++i2) {
            vec.add((PooledTestObject)this.pool.borrowObject((Object)0));
        }
        for (PooledTestObject element : vec) {
            element.setAbandoned(true);
        }
        int CONCURRENT_BORROWS = 5;
        Thread[] threads = new Thread[5];
        for (i = 0; i < 5; ++i) {
            threads[i] = new ConcurrentBorrower(vec);
            threads[i].start();
        }
        for (i = 0; i < 5; ++i) {
            threads[i].join();
        }
        for (PooledTestObject pto : vec) {
            if (!pto.isActive()) continue;
            this.pool.returnObject((Object)0, (Object)pto);
        }
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive(), (String)("numActive should have been 0, was " + this.pool.getNumActive()));
    }

    public void testDestroyModeAbandoned() throws Exception {
        this.abandonedConfig = new AbandonedConfig();
        this.abandonedConfig.setRemoveAbandonedOnMaintenance(true);
        this.abandonedConfig.setRemoveAbandonedTimeout(TestConstants.ONE_SECOND_DURATION);
        this.pool.close();
        this.pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SimpleFactory(0L, 0L), new GenericKeyedObjectPoolConfig(), this.abandonedConfig);
        this.pool.setTimeBetweenEvictionRuns(Duration.ofMillis(50L));
        PooledTestObject obj = (PooledTestObject)this.pool.borrowObject((Object)0);
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)obj.isDetached());
    }

    public void testDestroyModeNormal() throws Exception {
        this.abandonedConfig = new AbandonedConfig();
        this.pool.close();
        this.pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SimpleFactory(0L, 0L));
        this.pool.setMaxIdlePerKey(0);
        PooledTestObject obj = (PooledTestObject)this.pool.borrowObject((Object)0);
        this.pool.returnObject((Object)0, (Object)obj);
        Assertions.assertTrue((boolean)obj.isDestroyed());
        Assertions.assertFalse((boolean)obj.isDetached());
    }

    @Test
    public void testRemoveAbandonedWhileReturning() throws Exception {
        this.abandonedConfig = new AbandonedConfig();
        this.abandonedConfig.setRemoveAbandonedOnMaintenance(true);
        this.abandonedConfig.setRemoveAbandonedTimeout(TestConstants.ONE_SECOND_DURATION);
        this.pool.close();
        this.pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SimpleFactory(0L, 1000L), new GenericKeyedObjectPoolConfig(), this.abandonedConfig);
        int n = 10;
        this.pool.setMaxTotal(10);
        this.pool.setBlockWhenExhausted(false);
        this.pool.setTimeBetweenEvictionRuns(Duration.ofMillis(500L));
        this.pool.setTestOnReturn(true);
        PooledTestObject obj = (PooledTestObject)this.pool.borrowObject((Object)0);
        Thread.sleep(50L);
        this.pool.returnObject((Object)0, (Object)obj);
        PooledTestObject obj2 = (PooledTestObject)this.pool.borrowObject((Object)0);
        Assertions.assertEquals((Object)obj, (Object)obj2);
        Assertions.assertFalse((boolean)obj2.isDestroyed());
    }

    @Test
    public void testStackTrace() throws Exception {
        this.abandonedConfig.setRemoveAbandonedOnMaintenance(true);
        this.abandonedConfig.setLogAbandoned(true);
        this.abandonedConfig.setRemoveAbandonedTimeout(TestConstants.ONE_SECOND_DURATION);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        PrintWriter pw = new PrintWriter(bos);
        this.abandonedConfig.setLogWriter(pw);
        this.pool.setAbandonedConfig(this.abandonedConfig);
        this.pool.setTimeBetweenEvictionRuns(Duration.ofMillis(100L));
        PooledTestObject o1 = (PooledTestObject)this.pool.borrowObject((Object)0);
        Thread.sleep(2000L);
        Assertions.assertTrue((boolean)o1.isDestroyed());
        bos.flush();
        Assertions.assertTrue((boolean)baos.toString().contains("Pooled object"));
    }

    @Test
    public void testWhenExhaustedBlock() throws Exception {
        this.abandonedConfig.setRemoveAbandonedOnMaintenance(true);
        this.pool.setAbandonedConfig(this.abandonedConfig);
        this.pool.setTimeBetweenEvictionRuns(Duration.ofMillis(500L));
        this.pool.setMaxTotal(1);
        PooledTestObject o1 = (PooledTestObject)this.pool.borrowObject((Object)0);
        long startMillis = System.currentTimeMillis();
        PooledTestObject o2 = (PooledTestObject)this.pool.borrowObject((Object)0, 5000L);
        long endMillis = System.currentTimeMillis();
        this.pool.returnObject((Object)0, (Object)o2);
        Assertions.assertTrue((endMillis - startMillis < 5000L ? 1 : 0) != 0);
    }

    private static final class SimpleFactory
    implements KeyedPooledObjectFactory<Integer, PooledTestObject> {
        private final long destroyLatencyMillis;
        private final long validateLatencyMillis;

        public SimpleFactory() {
            this.destroyLatencyMillis = 0L;
            this.validateLatencyMillis = 0L;
        }

        public SimpleFactory(long destroyLatencyMillis, long validateLatencyMillis) {
            this.destroyLatencyMillis = destroyLatencyMillis;
            this.validateLatencyMillis = validateLatencyMillis;
        }

        public void activateObject(Integer key, PooledObject<PooledTestObject> obj) {
            ((PooledTestObject)obj.getObject()).setActive(true);
        }

        public void destroyObject(Integer key, PooledObject<PooledTestObject> obj) throws InterruptedException {
            this.destroyObject(key, obj, DestroyMode.NORMAL);
        }

        public void destroyObject(Integer key, PooledObject<PooledTestObject> obj, DestroyMode destroyMode) throws InterruptedException {
            ((PooledTestObject)obj.getObject()).setActive(false);
            Thread.yield();
            if (this.destroyLatencyMillis != 0L) {
                Thread.sleep(this.destroyLatencyMillis);
            }
            ((PooledTestObject)obj.getObject()).destroy(destroyMode);
        }

        public PooledObject<PooledTestObject> makeObject(Integer key) {
            return new DefaultPooledObject((Object)new PooledTestObject());
        }

        public void passivateObject(Integer key, PooledObject<PooledTestObject> obj) {
            ((PooledTestObject)obj.getObject()).setActive(false);
        }

        public boolean validateObject(Integer key, PooledObject<PooledTestObject> obj) {
            Waiter.sleepQuietly(this.validateLatencyMillis);
            return true;
        }
    }

    final class ConcurrentReturner
    extends Thread {
        private final PooledTestObject returned;

        public ConcurrentReturner(PooledTestObject obj) {
            this.returned = obj;
        }

        @Override
        public void run() {
            try {
                ConcurrentReturner.sleep(20L);
                TestAbandonedKeyedObjectPool.this.pool.returnObject((Object)0, (Object)this.returned);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    final class ConcurrentBorrower
    extends Thread {
        private final ArrayList<PooledTestObject> borrowed;

        public ConcurrentBorrower(ArrayList<PooledTestObject> borrowed) {
            this.borrowed = borrowed;
        }

        @Override
        public void run() {
            try {
                this.borrowed.add((PooledTestObject)TestAbandonedKeyedObjectPool.this.pool.borrowObject((Object)0));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

