/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.util;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.cxf.transport.jms.util.ResourceCloser;

public class JndiHelper {
    private static final List<String> ALLOWED_PROTOCOLS = Arrays.asList("vm://", "tcp://", "nio://", "ssl://", "http://", "https://", "ws://", "wss://");
    private Properties environment;

    public JndiHelper(Properties environment) {
        this.environment = environment;
        String providerUrl = environment.getProperty("java.naming.provider.url");
        if (providerUrl != null) {
            if (!ALLOWED_PROTOCOLS.stream().anyMatch(providerUrl::startsWith)) {
                throw new IllegalArgumentException("Unsafe protocol in JNDI URL: " + providerUrl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T lookup(String name, Class<T> requiredType) throws NamingException {
        InitialContext ctx = new InitialContext(this.environment);
        try {
            Object located = ctx.lookup(name);
            if (located == null) {
                throw new NameNotFoundException("JNDI object with [" + name + "] not found");
            }
            Object object = located;
            return (T)object;
        }
        finally {
            ResourceCloser.close(ctx);
        }
    }
}

