/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.control;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.configuration.Configuration;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.UnitConfiguration;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.controller.OutletReference;
import org.apache.torque.generator.configuration.controller.Output;
import org.apache.torque.generator.configuration.outlet.OutletConfiguration;
import org.apache.torque.generator.control.ControllerException;
import org.apache.torque.generator.control.ControllerHelper;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.control.existingtargetstrategy.AppendToTargetFileStrategy;
import org.apache.torque.generator.control.existingtargetstrategy.ExistingTargetStrategy;
import org.apache.torque.generator.control.existingtargetstrategy.MergeTargetFileStrategy;
import org.apache.torque.generator.control.existingtargetstrategy.ReplaceTargetFileStrategy;
import org.apache.torque.generator.control.existingtargetstrategy.SkipExistingTargetFileStrategy;
import org.apache.torque.generator.outlet.Outlet;
import org.apache.torque.generator.outlet.OutletResult;
import org.apache.torque.generator.processor.string.StringProcessor;
import org.apache.torque.generator.source.PostprocessorDefinition;
import org.apache.torque.generator.source.Source;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceException;
import org.apache.torque.generator.source.SourcePath;
import org.apache.torque.generator.source.SourcePathPointer;
import org.apache.torque.generator.source.SourceProcessConfiguration;
import org.apache.torque.generator.source.SourceProvider;
import org.apache.torque.generator.source.SourceTransformerDefinition;
import org.apache.torque.generator.source.skipDecider.SkipDecider;
import org.apache.torque.generator.source.transform.SourceTransformer;
import org.apache.torque.generator.source.transform.SourceTransformerException;

public class Controller {
    private static Log log = LogFactory.getLog(Controller.class);
    public static final String LAST_SOURCE_CHANGE_CACHE_FILE = "last-source-changes.checksums";
    public static final String NO_CHECKSUM_CONTENT = "[checksum could not be determined]";
    private static final List<ExistingTargetStrategy> EXISTING_TARGET_STRATEGIES;
    private final Map<String, Boolean> sourceModifiedCache = new HashMap<String, Boolean>();

    public void run(List<UnitDescriptor> unitDescriptors) throws GeneratorException {
        this.checkLogging();
        this.sourceModifiedCache.clear();
        Configuration configuration = this.readConfiguration(unitDescriptors);
        List<UnitConfiguration> unitConfigurations = configuration.getUnitConfigurations();
        ControllerState controllerState = new ControllerState();
        unitConfigurations.stream().forEach(unitConfiguration -> {
            try {
                this.processGenerationUnit(controllerState, (UnitConfiguration)unitConfiguration);
            }
            catch (GeneratorException e) {
                log.error((Object)e.getMessage());
                throw new RuntimeException(e);
            }
        });
        controllerState.getVariableStore().endGeneration();
    }

    protected void checkLogging() {
        String log4jConfiguration = System.getProperty("log4j2.configuration");
        if (log4jConfiguration != null) {
            log.info((Object)("Using external log4j2 configuration from " + log4jConfiguration));
            return;
        }
    }

    private Configuration readConfiguration(List<UnitDescriptor> unitDescriptors) throws ConfigurationException {
        log.info((Object)"readConfiguration() : Starting to read configuration files");
        Configuration configuration = new Configuration();
        configuration.addUnits(unitDescriptors);
        configuration.read();
        log.info((Object)"readConfiguration() : Configuration read.");
        return configuration;
    }

    protected void processGenerationUnit(ControllerState controllerState, UnitConfiguration unitConfiguration) throws GeneratorException {
        log.debug((Object)"processGenerationUnit() : start");
        unitConfiguration.getLoglevel().apply();
        log.debug((Object)"processGenerationUnit() : Loglevel applied.");
        controllerState.setUnitConfiguration(unitConfiguration);
        File sourceChecksumsFile = new File(unitConfiguration.getCacheDirectory(), LAST_SOURCE_CHANGE_CACHE_FILE);
        if (unitConfiguration.isRunOnlyOnSourceChange()) {
            try {
                controllerState.getLastGeneratedSourceChecksums().readFromFile(sourceChecksumsFile);
            }
            catch (IOException e) {
                throw new GeneratorException("could not read LastSourceChange checksum file" + sourceChecksumsFile.getAbsolutePath(), e);
            }
        }
        List<Output> outputList = unitConfiguration.getOutputList();
        outputList.stream().forEach(output -> {
            try {
                this.processOutput((Output)output, controllerState, unitConfiguration);
            }
            catch (GeneratorException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        });
        if (unitConfiguration.isRunOnlyOnSourceChange()) {
            try {
                controllerState.getThisGenerationSourceChecksums().writeToFile(sourceChecksumsFile);
            }
            catch (IOException e) {
                throw new GeneratorException("could not write LastSourceChange checksum file" + sourceChecksumsFile.getAbsolutePath(), e);
            }
        }
    }

    private void processOutput(Output output, ControllerState controllerState, UnitConfiguration unitConfiguration) throws GeneratorException {
        log.info((Object)("Processing output " + output.getName()));
        controllerState.setOutput(output);
        SourceProvider sourceProvider = output.getSourceProvider();
        SourceProvider overrideSourceProvider = unitConfiguration.getOverrideSourceProvider();
        if (overrideSourceProvider != null) {
            overrideSourceProvider = overrideSourceProvider.copy();
            overrideSourceProvider.copyNotSetSettingsFrom(sourceProvider);
            sourceProvider = overrideSourceProvider;
        }
        controllerState.setSourceProvider(sourceProvider);
        sourceProvider.init(unitConfiguration.getConfigurationHandlers(), controllerState);
        if (!sourceProvider.hasNext()) {
            log.info((Object)"No sources found, skipping output");
        }
        while (sourceProvider.hasNext()) {
            Source source = (Source)sourceProvider.next();
            if (unitConfiguration.isRunOnlyOnSourceChange() && !this.checkSourceModified(source, controllerState, unitConfiguration)) continue;
            this.processSourceInOutput(source, output, controllerState, unitConfiguration);
        }
        controllerState.setSourceProvider(null);
    }

    private void processSourceInOutput(Source source, Output output, ControllerState controllerState, UnitConfiguration unitConfiguration) throws GeneratorException {
        log.info((Object)("Processing source " + source.getDescription()));
        Object modelRoot = source.getRootElement();
        controllerState.setSourceFile(source.getSourceFile());
        SourceProcessConfiguration sourceProcessConfiguration = output.getSourceProcessConfiguration();
        modelRoot = this.transformSource(modelRoot, sourceProcessConfiguration.getTransformerDefinitions(), controllerState);
        controllerState.setModelRoot(modelRoot);
        String startElementsPath = sourceProcessConfiguration.getStartElementsPath();
        Iterator<SourcePathPointer> iterator = SourcePath.iteratePointer(null, null, modelRoot, startElementsPath);
        if (!iterator.hasNext()) {
            log.info((Object)("No start Elements found for path " + startElementsPath));
        }
        while (iterator.hasNext()) {
            SourcePathPointer pointer = iterator.next();
            Object model = pointer.getValue();
            String path = pointer.getPath();
            if (model instanceof SourceElement && path.startsWith("/")) {
                int slashIndex = path.indexOf(47, 1);
                path = slashIndex != -1 ? path.substring(slashIndex + 1) : "/";
            }
            controllerState.setModel(model, path);
            this.processModel(model, output, source, unitConfiguration, controllerState);
        }
    }

    protected void createOutputFilename(Output output, ControllerState controllerState) throws GeneratorException {
        if (output.getFilenameOutlet() == null) {
            if (output.getFilename() == null) {
                throw new ConfigurationException("neither filename nor filenameOutlet are set on output" + output);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Start generation of Output File path");
            }
            controllerState.setOutputFile(null);
            Outlet filenameOutlet = output.getFilenameOutlet();
            OutletReference contentOutletReference = new OutletReference(filenameOutlet.getName());
            controllerState.setRootOutletReference(contentOutletReference);
            controllerState.setOutletNamespace(output.getContentOutlet().getNamespace());
            filenameOutlet.beforeExecute(controllerState);
            OutletResult filenameResult = filenameOutlet.execute(controllerState);
            if (!filenameResult.isStringResult()) {
                throw new GeneratorException("The result of a filename generation must be a String, not a byte array");
            }
            String filename = filenameResult.getStringResult();
            filenameOutlet.afterExecute(controllerState);
            if (log.isDebugEnabled()) {
                log.debug((Object)("End generation of Output File path, result is " + filename));
            }
            output.setFilename(filename);
        }
    }

    private void processModel(Object model, Output output, Source source, UnitConfiguration unitConfiguration, ControllerState controllerState) throws GeneratorException {
        boolean success;
        File parentOutputDir;
        if (model == null) {
            throw new ControllerException("Null start element found in source for generating the filename of output file " + output);
        }
        log.debug((Object)("Processing new model " + model));
        ExistingTargetStrategy existingTargetStrategy = null;
        for (ExistingTargetStrategy candidate : EXISTING_TARGET_STRATEGIES) {
            if (!candidate.getStrategyName().equals(output.getExistingTargetStrategy())) continue;
            existingTargetStrategy = candidate;
            break;
        }
        if (existingTargetStrategy == null) {
            throw new ControllerException("existingTargetStrategy " + output.getExistingTargetStrategy() + " not found");
        }
        this.createOutputFilename(output, controllerState);
        File outputFile = ControllerHelper.getOutputFile(output.getOutputDirKey(), output.getFilename(), unitConfiguration);
        controllerState.setOutputFile(outputFile);
        if (!existingTargetStrategy.beforeGeneration(output.getOutputDirKey(), output.getFilename(), this.getOutputEncoding(output, unitConfiguration), unitConfiguration)) {
            log.info((Object)("Skipping generation of File " + outputFile.getAbsolutePath() + " because of existingTargetStrategy " + existingTargetStrategy.getStrategyName()));
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Start generation of File " + outputFile.getAbsolutePath()));
        }
        OutletReference contentOutletConfiguration = output.getContentOutlet();
        controllerState.setOutletNamespace(contentOutletConfiguration.getNamespace());
        controllerState.setRootOutletReference(contentOutletConfiguration);
        OutletConfiguration outletConfiguration = unitConfiguration.getOutletConfiguration();
        Outlet outlet = outletConfiguration.getOutlet(contentOutletConfiguration.getName());
        if (outlet == null) {
            throw new ControllerException("No outlet configured for outlet name \"" + contentOutletConfiguration.getName() + "\"");
        }
        SkipDecider skipDecider = output.getSourceProcessConfiguration().getSkipDecider();
        if (skipDecider != null) {
            if (!skipDecider.proceed(controllerState)) {
                log.debug((Object)("SkipDecider " + skipDecider.getClass().getName() + " decided to skip generation of file " + controllerState.getOutputFile()));
                return;
            }
            log.debug((Object)("SkipDecider " + skipDecider.getClass().getName() + " decided to proceed"));
        }
        if ((parentOutputDir = controllerState.getOutputFile().getParentFile()) != null && !parentOutputDir.isDirectory() && !(success = parentOutputDir.mkdirs())) {
            throw new ControllerException("Could not create directory \"" + parentOutputDir.getAbsolutePath() + "\"");
        }
        outlet.beforeExecute(controllerState);
        OutletResult result = outlet.execute(controllerState);
        outlet.afterExecute(controllerState);
        if (result.isStringResult()) {
            for (PostprocessorDefinition postprocessorDefinition : output.getPostprocessorDefinitions()) {
                StringProcessor postprocessor = postprocessorDefinition.getPostprocessor();
                String postprocessedResult = postprocessor.process(result.getStringResult());
                result = new OutletResult(postprocessedResult);
            }
        }
        existingTargetStrategy.afterGeneration(output.getOutputDirKey(), output.getFilename(), this.getOutputEncoding(output, unitConfiguration), result, unitConfiguration);
        controllerState.getVariableStore().endFile();
        if (log.isDebugEnabled()) {
            log.debug((Object)("End generation of Output File " + controllerState.getOutputFile()));
        }
    }

    public Object transformSource(Object sourceRoot, List<SourceTransformerDefinition> transformerDefinitions, ControllerState controllerState) throws SourceTransformerException, SourceException {
        Object toTransform = sourceRoot;
        Object result = sourceRoot;
        for (SourceTransformerDefinition transformerDefinition : transformerDefinitions) {
            SourceTransformer sourceTransformer = transformerDefinition.getSourceTransformer();
            log.debug((Object)("Applying source transformer " + sourceTransformer.getClass().getName() + " to source root object " + toTransform));
            result = sourceTransformer.transform(result, controllerState);
            if (result == null) {
                throw new SourceTransformerException("Transformer " + sourceTransformer.getClass().getName() + " returned null for element " + toTransform);
            }
            log.debug((Object)"Transformation ended");
            toTransform = result;
        }
        return result;
    }

    private String getOutputEncoding(Output output, UnitConfiguration unitConfiguration) {
        if (output.getEncoding() != null) {
            return output.getEncoding();
        }
        if (unitConfiguration.getDefaultOutputEncoding() != null) {
            return unitConfiguration.getDefaultOutputEncoding();
        }
        return Charset.defaultCharset().displayName();
    }

    private boolean checkSourceModified(Source source, ControllerState controllerState, UnitConfiguration unitConfiguration) {
        File sourceFile = source.getSourceFile();
        if (sourceFile == null) {
            log.debug((Object)"checkSourceModified(): source file cannot be determined, return true");
            return true;
        }
        String sourceChangeKey = this.getSourceChangeKey(unitConfiguration, sourceFile);
        if (this.sourceModifiedCache.get(sourceChangeKey) != null) {
            return this.sourceModifiedCache.get(sourceChangeKey);
        }
        Date sourceLastModified = source.getLastModified();
        if (sourceLastModified == null) {
            log.debug((Object)"checkSourceModified(): lastModified date of source cannot be determined, return true");
            this.sourceModifiedCache.put(sourceChangeKey, true);
            return true;
        }
        controllerState.getThisGenerationSourceChecksums().setModificationDate(sourceChangeKey, sourceLastModified);
        byte[] sourceChecksum = source.getContentChecksum();
        controllerState.getThisGenerationSourceChecksums().setChecksum(sourceChangeKey, sourceChecksum);
        Date lastGenerationTime = controllerState.getLastGeneratedSourceChecksums().getModificationDate(sourceChangeKey);
        if (lastGenerationTime == null) {
            log.debug((Object)"checkSourceModified(): lastGenerationTime does not exist, return true");
            this.sourceModifiedCache.put(sourceChangeKey, true);
            return true;
        }
        if (lastGenerationTime.before(sourceLastModified)) {
            log.debug((Object)("checkSourceModified(): lastGenerationTime was before source was modified (" + lastGenerationTime + " < " + sourceLastModified + "), return true"));
            this.sourceModifiedCache.put(sourceChangeKey, true);
            return true;
        }
        byte[] lastGeneratedChecksum = controllerState.getLastGeneratedSourceChecksums().getChecksum(sourceChangeKey);
        if (!Arrays.equals(lastGeneratedChecksum, sourceChecksum)) {
            log.debug((Object)"checkSourceModified():  different checksum, return true");
            this.sourceModifiedCache.put(sourceChangeKey, true);
            return true;
        }
        log.debug((Object)"checkSourceModified() : returning false");
        this.sourceModifiedCache.put(sourceChangeKey, false);
        return false;
    }

    private String getSourceChangeKey(UnitConfiguration unitConfiguration, File sourceFile) {
        String sourceChangeCacheKey = unitConfiguration.getTemplateSetName() + ":" + sourceFile.getAbsolutePath();
        return sourceChangeCacheKey;
    }

    static {
        ArrayList<ExistingTargetStrategy> existingTargetStrategies = new ArrayList<ExistingTargetStrategy>();
        existingTargetStrategies.add(new ReplaceTargetFileStrategy());
        existingTargetStrategies.add(new SkipExistingTargetFileStrategy());
        existingTargetStrategies.add(new MergeTargetFileStrategy());
        existingTargetStrategies.add(new AppendToTargetFileStrategy());
        EXISTING_TARGET_STRATEGIES = Collections.unmodifiableList(existingTargetStrategies);
    }
}

