/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.revwalk.AddUnseenToBitmapFilter;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexBuilder;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexRemapper;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.BitmapWalker;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.util.BlockList;
import org.eclipse.jgit.util.SystemReader;

class PackWriterBitmapPreparer {
    private static final int DAY_IN_SECONDS = 86400;
    private static final Comparator<RevCommit> ORDER_BY_REVERSE_TIMESTAMP = new Comparator<RevCommit>(){

        @Override
        public int compare(RevCommit a, RevCommit b) {
            return Integer.signum(b.getCommitTime() - a.getCommitTime());
        }
    };
    private final ObjectReader reader;
    private final ProgressMonitor pm;
    private final Set<? extends ObjectId> want;
    private final PackBitmapIndexBuilder writeBitmaps;
    private final BitmapIndexImpl commitBitmapIndex;
    private final PackBitmapIndexRemapper bitmapRemapper;
    private final BitmapIndexImpl bitmapIndex;
    private final int contiguousCommitCount;
    private final int recentCommitCount;
    private final int recentCommitSpan;
    private final int distantCommitSpan;
    private final int excessiveBranchCount;
    private final long inactiveBranchTimestamp;

    PackWriterBitmapPreparer(ObjectReader reader, PackBitmapIndexBuilder writeBitmaps, ProgressMonitor pm, Set<? extends ObjectId> want, PackConfig config) throws IOException {
        this.reader = reader;
        this.writeBitmaps = writeBitmaps;
        this.pm = pm;
        this.want = want;
        this.commitBitmapIndex = new BitmapIndexImpl(writeBitmaps);
        this.bitmapRemapper = PackBitmapIndexRemapper.newPackBitmapIndex(reader.getBitmapIndex(), writeBitmaps);
        this.bitmapIndex = new BitmapIndexImpl(this.bitmapRemapper);
        this.contiguousCommitCount = config.getBitmapContiguousCommitCount();
        this.recentCommitCount = config.getBitmapRecentCommitCount();
        this.recentCommitSpan = config.getBitmapRecentCommitSpan();
        this.distantCommitSpan = config.getBitmapDistantCommitSpan();
        this.excessiveBranchCount = config.getBitmapExcessiveBranchCount();
        long now = SystemReader.getInstance().getCurrentTime();
        long ageInSeconds = config.getBitmapInactiveBranchAgeInDays() * 86400;
        this.inactiveBranchTimestamp = now / 1000L - ageInSeconds;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Collection<BitmapCommit> selectCommits(int expectedCommitCount, Set<? extends ObjectId> excludeFromBitmapSelection) throws IncorrectObjectTypeException, IOException, MissingObjectException {
        var3_3 = null;
        var4_5 = null;
        try {
            rw = new RevWalk(this.reader);
            try {
                block29: {
                    block30: {
                        rw2 = new RevWalk(this.reader);
                        this.pm.beginTask(JGitText.get().selectingCommits, 0);
                        rw.setRetainBody(false);
                        selectionHelper = this.captureOldAndNewCommits(rw, expectedCommitCount, excludeFromBitmapSelection);
                        this.pm.endTask();
                        newCommits = selectionHelper.getCommitCount();
                        selections = new BlockList<BitmapCommit>(selectionHelper.reusedCommits.size() + newCommits / this.recentCommitSpan + 1);
                        for (BitmapCommit var10_14 : selectionHelper.reusedCommits) {
                            selections.add(var10_14);
                        }
                        if (newCommits != 0) break block30;
                        var11_13 = selectionHelper.newWants.iterator();
                        if (true) ** GOTO lbl42
                    }
                    this.pm.beginTask(JGitText.get().selectingCommits, newCommits);
                    var10_17 = this.want.size();
                    seen = this.commitBitmapIndex.newBitmapBuilder();
                    seen.or(selectionHelper.reusedCommitsBitmap);
                    rw2.setRetainBody(false);
                    rw2.setRevFilter(new NotInBitmapFilter(seen));
                    var13_18 = selectionHelper.newWantsByNewest.iterator();
                    if (true) ** GOTO lbl105
                    finally {
                        if (rw2 == null) break block29;
                        rw2.close();
                    }
                }
                if (rw == null) return v0;
                rw.close();
                return v0;
                do {
                    var10_16 = var11_13.next();
                    selections.add(new BitmapCommit(var10_16, false, 0));
lbl42:
                    // 2 sources

                } while (var11_13.hasNext());
                v0 = selections;
                return v0;
                do {
                    var12_19 = var13_18.next();
                    tipBitmap = this.commitBitmapIndex.newBitmapBuilder();
                    rw2.markStart((RevCommit)rw2.peel(rw2.parseAny(var12_19)));
                    while ((rc2 = rw2.next()) != null) {
                        tipBitmap.addObject(rc2, 1);
                    }
                    cardinality = tipBitmap.cardinality();
                    seen.or(tipBitmap);
                    chains = new ArrayList<ArrayList<E>>();
                    isActiveBranch = true;
                    if (var10_17 > this.excessiveBranchCount && !this.isRecentCommit(var12_19)) {
                        isActiveBranch = false;
                    }
                    index = -1;
                    nextIn = this.nextSpan(cardinality);
                    nextFlg = nextIn == this.distantCommitSpan ? 1 : 0;
                    for (RevCommit var22_31 : selectionHelper) {
                        distanceFromTip = cardinality - index - 1;
                        if (distanceFromTip == 0) break;
                        if (!tipBitmap.contains(var22_31)) continue;
                        ++index;
                        --nextIn;
                        this.pm.update(1);
                        if (selectionHelper.newWants.remove(var22_31)) {
                            if (nextIn > 0) {
                                nextFlg = 0;
                            }
                        } else {
                            stillInSpan = nextIn >= 0;
                            isMergeCommit = var22_31.getParentCount() > 1;
                            v1 = mustPick = nextIn <= -this.recentCommitSpan || isActiveBranch != false && distanceFromTip <= this.contiguousCommitCount || distanceFromTip == 1;
                            if (!mustPick && (stillInSpan || !isMergeCommit)) continue;
                        }
                        flags = nextFlg;
                        nextIn = this.nextSpan(distanceFromTip);
                        nextFlg = nextIn == this.distantCommitSpan ? 1 : 0;
                        bitmap = this.commitBitmapIndex.newBitmapBuilder();
                        rw.reset();
                        rw.markStart(var22_31);
                        rw.setRevFilter(new AddUnseenToBitmapFilter(selectionHelper.reusedCommitsBitmap, bitmap));
                        while (rw.next() != null) {
                        }
                        longestAncestorChain /* !! */  = null;
                        for (List var28_40 : chains) {
                            mostRecentCommit = (BitmapCommit)var28_40.get(var28_40.size() - 1);
                            if (!bitmap.contains(mostRecentCommit) || longestAncestorChain /* !! */  != null && longestAncestorChain /* !! */ .size() >= var28_40.size()) continue;
                            longestAncestorChain /* !! */  = var28_40;
                        }
                        if (longestAncestorChain /* !! */  == null) {
                            longestAncestorChain /* !! */  = new ArrayList<BitmapCommit>();
                            chains.add(longestAncestorChain /* !! */ );
                        }
                        longestAncestorChain /* !! */ .add(new BitmapCommit(var22_31, longestAncestorChain /* !! */ .isEmpty() == false, flags));
                        this.writeBitmaps.addBitmap((AnyObjectId)var22_31, bitmap, 0);
                    }
                    for (List var22_32 : chains) {
                        selections.addAll(var22_32);
                    }
lbl105:
                    // 2 sources

                } while (var13_18.hasNext());
                this.writeBitmaps.clearBitmaps();
                for (AnyObjectId var12_21 : selectionHelper.newWants) {
                    selections.add(new BitmapCommit(var12_21, false, 0));
                }
                this.pm.endTask();
                return selections;
            }
            catch (Throwable var4_6) {
                if (var3_3 == null) {
                    var3_3 = var4_6;
                } else if (var3_3 != var4_6) {
                    var3_3.addSuppressed(var4_6);
                }
                if (rw == null) throw var3_3;
                rw.close();
                throw var3_3;
            }
        }
        catch (Throwable var4_7) {
            if (var3_3 == null) {
                var3_3 = var4_7;
                throw var3_3;
            }
            if (var3_3 == var4_7) throw var3_3;
            var3_3.addSuppressed(var4_7);
            throw var3_3;
        }
    }

    private boolean isRecentCommit(RevCommit revCommit) {
        return (long)revCommit.getCommitTime() > this.inactiveBranchTimestamp;
    }

    private CommitSelectionHelper captureOldAndNewCommits(RevWalk rw, int expectedCommitCount, Set<? extends ObjectId> excludeFromBitmapSelection) throws IncorrectObjectTypeException, IOException, MissingObjectException {
        RevCommit rc;
        BitmapIndexImpl.CompressedBitmapBuilder reuse = this.commitBitmapIndex.newBitmapBuilder();
        ArrayList<BitmapCommit> reuseCommits = new ArrayList<BitmapCommit>();
        for (PackBitmapIndexRemapper.Entry entry : this.bitmapRemapper) {
            RevObject revObject;
            if ((entry.getFlags() & 1) != 1 || !((revObject = rw.peel(rw.parseAny(entry))) instanceof RevCommit)) continue;
            RevCommit rc2 = (RevCommit)revObject;
            reuseCommits.add(new BitmapCommit(rc2, false, entry.getFlags()));
            if (reuse.contains(rc2)) continue;
            EWAHCompressedBitmap bitmap = this.bitmapRemapper.ofObjectType(this.bitmapRemapper.getBitmap(rc2), 1);
            reuse.or(new BitmapIndexImpl.CompressedBitmap(bitmap, this.commitBitmapIndex));
        }
        ArrayList<RevCommit> newWantsByNewest = new ArrayList<RevCommit>(this.want.size());
        HashSet<RevCommit> newWants = new HashSet<RevCommit>(this.want.size());
        for (AnyObjectId anyObjectId : this.want) {
            RevObject ro = rw.peel(rw.parseAny(anyObjectId));
            if (!(ro instanceof RevCommit) || reuse.contains(ro) || excludeFromBitmapSelection.contains(ro)) continue;
            RevCommit rc3 = (RevCommit)ro;
            rw.markStart(rc3);
            newWants.add(rc3);
            newWantsByNewest.add(rc3);
        }
        rw.setRevFilter(new NotInBitmapFilter(reuse));
        RevCommit[] revCommitArray = new RevCommit[expectedCommitCount];
        int pos = revCommitArray.length;
        while ((rc = rw.next()) != null && pos > 0) {
            revCommitArray[--pos] = rc;
            this.pm.update(1);
        }
        Collections.sort(newWantsByNewest, ORDER_BY_REVERSE_TIMESTAMP);
        return new CommitSelectionHelper(newWants, revCommitArray, pos, newWantsByNewest, reuse, reuseCommits);
    }

    int nextSpan(int distanceFromTip) {
        if (distanceFromTip < 0) {
            throw new IllegalArgumentException();
        }
        if (distanceFromTip <= this.recentCommitCount) {
            return this.recentCommitSpan;
        }
        int next = Math.min(distanceFromTip - this.recentCommitCount, this.distantCommitSpan);
        return Math.max(next, this.recentCommitSpan);
    }

    BitmapWalker newBitmapWalker() {
        return new BitmapWalker(new ObjectWalk(this.reader), this.bitmapIndex, null);
    }

    static final class BitmapCommit
    extends ObjectId {
        private final boolean reuseWalker;
        private final int flags;

        BitmapCommit(AnyObjectId objectId, boolean reuseWalker, int flags) {
            super(objectId);
            this.reuseWalker = reuseWalker;
            this.flags = flags;
        }

        boolean isReuseWalker() {
            return this.reuseWalker;
        }

        int getFlags() {
            return this.flags;
        }
    }

    private static final class CommitSelectionHelper
    implements Iterable<RevCommit> {
        final Set<? extends ObjectId> newWants;
        final List<RevCommit> newWantsByNewest;
        final BitmapIndex.BitmapBuilder reusedCommitsBitmap;
        final List<BitmapCommit> reusedCommits;
        final RevCommit[] newCommitsByOldest;
        final int newCommitStartPos;

        CommitSelectionHelper(Set<? extends ObjectId> newWants, RevCommit[] commitsByOldest, int commitStartPos, List<RevCommit> newWantsByNewest, BitmapIndex.BitmapBuilder reusedCommitsBitmap, List<BitmapCommit> reuse) {
            this.newWants = newWants;
            this.newCommitsByOldest = commitsByOldest;
            this.newCommitStartPos = commitStartPos;
            this.newWantsByNewest = newWantsByNewest;
            this.reusedCommitsBitmap = reusedCommitsBitmap;
            this.reusedCommits = reuse;
        }

        @Override
        public Iterator<RevCommit> iterator() {
            return new Iterator<RevCommit>(){
                int pos;
                {
                    this.pos = commitSelectionHelper.newCommitStartPos;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < newCommitsByOldest.length;
                }

                @Override
                public RevCommit next() {
                    return newCommitsByOldest[this.pos++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        int getCommitCount() {
            return this.newCommitsByOldest.length - this.newCommitStartPos;
        }
    }

    private static class NotInBitmapFilter
    extends RevFilter {
        private final BitmapIndex.BitmapBuilder bitmap;

        NotInBitmapFilter(BitmapIndex.BitmapBuilder bitmap) {
            this.bitmap = bitmap;
        }

        @Override
        public final boolean include(RevWalk rw, RevCommit c) {
            if (!this.bitmap.contains(c)) {
                return true;
            }
            RevCommit[] revCommitArray = c.getParents();
            int n = revCommitArray.length;
            int n2 = 0;
            while (n2 < n) {
                RevCommit p = revCommitArray[n2];
                p.add(RevFlag.SEEN);
                ++n2;
            }
            return false;
        }

        @Override
        public final NotInBitmapFilter clone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean requiresCommitBody() {
            return false;
        }
    }
}

