/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoverySelector;

@API(status=API.Status.EXPERIMENTAL, since="1.9")
public class IterationSelector
implements DiscoverySelector {
    private final DiscoverySelector parentSelector;
    private final SortedSet<Integer> iterationIndices;

    IterationSelector(DiscoverySelector parentSelector, int ... iterationIndices) {
        this.parentSelector = parentSelector;
        this.iterationIndices = this.toSortedSet(iterationIndices);
    }

    private SortedSet<Integer> toSortedSet(int[] iterationIndices) {
        return Arrays.stream(iterationIndices).boxed().collect(Collectors.collectingAndThen(Collectors.toCollection(TreeSet::new), Collections::unmodifiableSortedSet));
    }

    public DiscoverySelector getParentSelector() {
        return this.parentSelector;
    }

    public SortedSet<Integer> getIterationIndices() {
        return this.iterationIndices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IterationSelector that = (IterationSelector)o;
        return this.parentSelector.equals(that.parentSelector) && this.iterationIndices.equals(that.iterationIndices);
    }

    public int hashCode() {
        return Objects.hash(this.parentSelector, this.iterationIndices);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("parentSelector", (Object)this.parentSelector).append("iterationIndices", this.iterationIndices).toString();
    }
}

