/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util.context;

import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.PassivationCapable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.deltaspike.core.util.context.ContextualInstanceInfo;
import org.apache.deltaspike.core.util.context.ContextualStorage;

public abstract class AbstractContext
implements Context {
    private final boolean passivatingScope;

    protected AbstractContext(BeanManager beanManager) {
        this.passivatingScope = beanManager.isPassivatingScope(this.getScope());
    }

    protected abstract ContextualStorage getContextualStorage(Contextual<?> var1, boolean var2);

    protected List<ContextualStorage> getActiveContextualStorages() {
        ArrayList<ContextualStorage> result = new ArrayList<ContextualStorage>();
        result.add(this.getContextualStorage(null, false));
        return result;
    }

    public boolean isPassivatingScope() {
        return this.passivatingScope;
    }

    public <T> T get(Contextual<T> bean) {
        this.checkActive();
        ContextualStorage storage = this.getContextualStorage(bean, false);
        if (storage == null) {
            return null;
        }
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(storage.getBeanKey(bean));
        if (contextualInstanceInfo == null) {
            return null;
        }
        return (T)contextualInstanceInfo.getContextualInstance();
    }

    public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
        Object instance;
        if (creationalContext == null) {
            return this.get(bean);
        }
        this.checkActive();
        if (this.passivatingScope && !(bean instanceof PassivationCapable)) {
            throw new IllegalStateException(bean.toString() + " doesn't implement " + PassivationCapable.class.getName());
        }
        ContextualStorage storage = this.getContextualStorage(bean, true);
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(storage.getBeanKey(bean));
        if (contextualInstanceInfo != null && (instance = contextualInstanceInfo.getContextualInstance()) != null) {
            return (T)instance;
        }
        return storage.createContextualInstance(bean, creationalContext);
    }

    public boolean destroy(Contextual bean) {
        ContextualStorage storage = this.getContextualStorage(bean, false);
        if (storage == null) {
            return false;
        }
        ContextualInstanceInfo<?> contextualInstanceInfo = storage.getStorage().remove(storage.getBeanKey(bean));
        if (contextualInstanceInfo == null) {
            return false;
        }
        AbstractContext.destroyBean(bean, contextualInstanceInfo);
        return true;
    }

    public void destroyAllActive() {
        List<ContextualStorage> storages = this.getActiveContextualStorages();
        if (storages == null) {
            return;
        }
        for (ContextualStorage storage : storages) {
            if (storage == null) continue;
            AbstractContext.destroyAllActive(storage);
        }
    }

    public static Map<Object, ContextualInstanceInfo<?>> destroyAllActive(ContextualStorage storage) {
        HashMap contextMap = new HashMap(storage.getStorage());
        storage.getStorage().clear();
        for (Map.Entry entry : contextMap.entrySet()) {
            Contextual<?> bean = storage.getBean(entry.getKey());
            ContextualInstanceInfo contextualInstanceInfo = (ContextualInstanceInfo)entry.getValue();
            AbstractContext.destroyBean(bean, contextualInstanceInfo);
        }
        return contextMap;
    }

    public static void destroyBean(Contextual bean, ContextualInstanceInfo<?> contextualInstanceInfo) {
        bean.destroy(contextualInstanceInfo.getContextualInstance(), contextualInstanceInfo.getCreationalContext());
    }

    protected void checkActive() {
        if (!this.isActive()) {
            throw new ContextNotActiveException("CDI context with scope annotation @" + this.getScope().getName() + " is not active with respect to the current thread");
        }
    }
}

