/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.perspective;

import org.apache.directory.studio.common.ui.CommonUIUtils;
import org.apache.directory.studio.connection.ui.wizards.NewConnectionWizard;
import org.apache.directory.studio.ldapbrowser.common.wizards.NewContextEntryWizard;
import org.apache.directory.studio.ldapbrowser.common.wizards.NewEntryWizard;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.BrowserView;
import org.apache.directory.studio.ldapbrowser.ui.views.connection.ConnectionView;
import org.apache.directory.studio.ldapbrowser.ui.views.modificationlogs.ModificationLogsView;
import org.apache.directory.studio.ldapbrowser.ui.views.searchlogs.SearchLogsView;
import org.apache.directory.studio.ldapbrowser.ui.wizards.BatchOperationWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.NewBookmarkWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.NewSearchWizard;
import org.apache.directory.studio.ldifeditor.wizards.NewLdifFileWizard;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

public class BrowserPerspective
implements IPerspectiveFactory {
    private static final String PROGRESS_VIEW_ID = "org.eclipse.ui.views.ProgressView";
    private static final String ERROR_LOG_VIEW_ID = "org.eclipse.pde.runtime.LogView";

    public static String getId() {
        return "org.apache.directory.studio.ldapbrowser.ui.perspective.BrowserPerspective";
    }

    public void createInitialLayout(IPageLayout layout) {
        this.defineActions(layout);
        this.defineLayout(layout);
        layout.addPerspectiveShortcut("org.apache.directory.studio.schemaeditor.perspective");
        layout.addPerspectiveShortcut("org.apache.directory.studio.ldapbrowser.ui.perspective.BrowserPerspective");
    }

    private void defineActions(IPageLayout layout) {
        layout.addNewWizardShortcut(NewConnectionWizard.getId());
        layout.addNewWizardShortcut(NewEntryWizard.getId());
        layout.addNewWizardShortcut(NewContextEntryWizard.getId());
        layout.addNewWizardShortcut(NewSearchWizard.getId());
        layout.addNewWizardShortcut(NewBookmarkWizard.getId());
        layout.addNewWizardShortcut(BatchOperationWizard.getId());
        layout.addNewWizardShortcut(NewLdifFileWizard.getId());
        layout.addShowViewShortcut(ConnectionView.getId());
        layout.addShowViewShortcut(BrowserView.getId());
        layout.addShowViewShortcut(ModificationLogsView.getId());
        layout.addShowViewShortcut(SearchLogsView.getId());
        layout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
        layout.addShowViewShortcut(PROGRESS_VIEW_ID);
        layout.addShowViewShortcut(ERROR_LOG_VIEW_ID);
    }

    private void defineLayout(IPageLayout layout) {
        String editorArea = layout.getEditorArea();
        IFolderLayout browserFolder = layout.createFolder("browserFolder", 1, 0.25f, editorArea);
        browserFolder.addView(BrowserView.getId());
        IFolderLayout connectionFolder = layout.createFolder("connectionFolder", 4, 0.75f, "browserFolder");
        connectionFolder.addView(ConnectionView.getId());
        IFolderLayout outlineFolder = layout.createFolder("outlineFolder", 2, 0.75f, editorArea);
        outlineFolder.addView("org.eclipse.ui.views.ContentOutline");
        IFolderLayout progessFolder = layout.createFolder("progressFolder", 4, 0.75f, "outlineFolder");
        progessFolder.addView(PROGRESS_VIEW_ID);
        IFolderLayout logFolder = layout.createFolder("logFolder", 4, 0.75f, editorArea);
        logFolder.addView(ModificationLogsView.getId());
        logFolder.addView(SearchLogsView.getId());
        logFolder.addView(ERROR_LOG_VIEW_ID);
        logFolder.addPlaceholder("*");
        boolean isIDE = CommonUIUtils.isIDEEnvironment();
        if (!isIDE) {
            layout.getViewLayout(BrowserView.getId()).setCloseable(false);
            layout.getViewLayout(ConnectionView.getId()).setCloseable(false);
            layout.getViewLayout("org.eclipse.ui.views.ContentOutline").setCloseable(false);
            layout.getViewLayout(PROGRESS_VIEW_ID).setCloseable(false);
            layout.getViewLayout(ModificationLogsView.getId()).setCloseable(false);
            layout.getViewLayout(SearchLogsView.getId()).setCloseable(false);
        }
    }
}

