/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.rocketmq.cloudevent.impl;

import io.cloudevents.SpecVersion;
import io.cloudevents.core.data.BytesCloudEventData;
import io.cloudevents.core.message.impl.BaseGenericBinaryMessageReaderImpl;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.eventmesh.storage.rocketmq.cloudevent.impl.RocketMQHeaders;

public class RocketMQBinaryMessageReader
extends BaseGenericBinaryMessageReaderImpl<String, String> {
    private final Map<String, String> headers;

    public RocketMQBinaryMessageReader(SpecVersion version, Map<String, String> headers, byte[] payload) {
        super(version, payload != null && payload.length > 0 ? BytesCloudEventData.wrap((byte[])payload) : null);
        Objects.requireNonNull(headers);
        this.headers = headers;
    }

    protected boolean isContentTypeHeader(String key) {
        return key.equals(RocketMQHeaders.CONTENT_TYPE);
    }

    protected boolean isCloudEventsHeader(String key) {
        return true;
    }

    protected String toCloudEventsKey(String key) {
        return key.toLowerCase();
    }

    protected void forEachHeader(BiConsumer<String, String> fn) {
        this.headers.forEach(fn);
    }

    protected String toCloudEventsValue(String value) {
        return value;
    }
}

