/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.dbsync.binlog.event;

import com.taobao.tddl.dbsync.binlog.LogBuffer;
import com.taobao.tddl.dbsync.binlog.LogEvent;
import com.taobao.tddl.dbsync.binlog.event.FormatDescriptionLogEvent;
import com.taobao.tddl.dbsync.binlog.event.LogHeader;
import java.util.UUID;

public class GtidLogEvent
extends LogEvent {
    public static final int ENCODED_FLAG_LENGTH = 1;
    public static final int ENCODED_SID_LENGTH = 16;
    public static final int LOGICAL_TIMESTAMP_TYPE_CODE = 2;
    public static final UUID UUID_ZERO = new UUID(0L, 0L);
    private boolean commitFlag;
    private UUID sid;
    private long gno;
    private long lastCommitted;
    private long sequenceNumber;

    public GtidLogEvent(LogHeader header, LogBuffer buffer, FormatDescriptionLogEvent descriptionEvent) {
        super(header);
        int commonHeaderLen = descriptionEvent.commonHeaderLen;
        buffer.position(commonHeaderLen);
        this.commitFlag = buffer.getUint8() != 0;
        long high = buffer.getBeLong64();
        long low = buffer.getBeLong64();
        this.sid = high == 0L && low == 0L ? UUID_ZERO : new UUID(high, low);
        this.gno = buffer.getLong64();
        if (buffer.hasRemaining() && buffer.remaining() > 16 && buffer.getUint8() == 2) {
            this.lastCommitted = buffer.getLong64();
            this.sequenceNumber = buffer.getLong64();
        }
    }

    public boolean isCommitFlag() {
        return this.commitFlag;
    }

    public UUID getSid() {
        return this.sid;
    }

    public long getGno() {
        return this.gno;
    }

    public long getLastCommitted() {
        return this.lastCommitted;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String getGtidStr() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.sid.toString()).append(":");
        sb.append(this.gno);
        return sb.toString();
    }
}

