/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.channelz;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.InternalInstrumented;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ChannelzUtils {
    private static final Logger logger = LogManager.getLogger(ChannelzUtils.class);
    private static final long timeout = 3000L;

    private ChannelzUtils() {
    }

    public static <T> T getResult(String name, InternalInstrumented<T> instrumented) {
        if (instrumented == null) {
            return null;
        }
        ListenableFuture future = instrumented.getStats();
        return ChannelzUtils.unwrapFuture(name, future);
    }

    public static <T> List<T> getResults(String name, List<InternalInstrumented<T>> instrumentedList) {
        Objects.requireNonNull(instrumentedList, "instrumentedList");
        ArrayList<ListenableFuture> listenableFutures = new ArrayList<ListenableFuture>(instrumentedList.size());
        for (InternalInstrumented<T> each : instrumentedList) {
            listenableFutures.add(each.getStats());
        }
        ListenableFuture listListenableFuture = Futures.allAsList(listenableFutures);
        return (List)ChannelzUtils.unwrapFuture(name, listListenableFuture);
    }

    private static <T> T unwrapFuture(String name, ListenableFuture<T> future) {
        try {
            return (T)future.get(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            logger.info("ExecutionError {} {}", (Object)name, (Object)e.getMessage());
        }
        catch (TimeoutException e) {
            logger.info("Timeout {} {}", (Object)name, (Object)e.getMessage());
        }
        return null;
    }
}

