/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.instance.spring.support;

import java.util.ArrayList;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;

public class PropertyPlaceholderConfigurer
extends org.springframework.beans.factory.config.PropertyPlaceholderConfigurer
implements ResourceLoaderAware,
InitializingBean {
    private static final String PLACEHOLDER_PREFIX = "${";
    private static final String PLACEHOLDER_SUFFIX = "}";
    public static ThreadLocal<Properties> propertiesLocal = ThreadLocal.withInitial(Properties::new);
    private ResourceLoader loader;
    private String[] locationNames;

    public PropertyPlaceholderConfigurer() {
        this.setIgnoreUnresolvablePlaceholders(true);
    }

    public void setResourceLoader(ResourceLoader loader) {
        this.loader = loader;
    }

    public void setLocationNames(String[] locations) {
        this.locationNames = locations;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.loader, (String)"no resourceLoader");
        if (this.locationNames != null) {
            for (int i = 0; i < this.locationNames.length; ++i) {
                this.locationNames[i] = this.resolveSystemPropertyPlaceholders(this.locationNames[i]);
            }
        }
        if (this.locationNames != null) {
            ArrayList<Resource> resources = new ArrayList<Resource>(this.locationNames.length);
            for (String location : this.locationNames) {
                if ((location = this.trimToNull(location)) == null) continue;
                resources.add(this.loader.getResource(location));
            }
            super.setLocations(resources.toArray(new Resource[resources.size()]));
        }
    }

    private String resolveSystemPropertyPlaceholders(String text) {
        StringBuilder buf = new StringBuilder(text);
        int startIndex = buf.indexOf(PLACEHOLDER_PREFIX);
        while (startIndex >= 0) {
            int endIndex = buf.indexOf(PLACEHOLDER_SUFFIX, startIndex + PLACEHOLDER_PREFIX.length());
            if (endIndex != -1) {
                String placeholder = buf.substring(startIndex + PLACEHOLDER_PREFIX.length(), endIndex);
                int nextIndex = endIndex + PLACEHOLDER_SUFFIX.length();
                try {
                    String value = this.resolveSystemPropertyPlaceholder(placeholder);
                    if (value != null) {
                        buf.replace(startIndex, endIndex + PLACEHOLDER_SUFFIX.length(), value);
                        nextIndex = startIndex + value.length();
                    } else {
                        System.err.println("Could not resolve placeholder '" + placeholder + "' in [" + text + "] as system property: neither system property nor environment variable found");
                    }
                }
                catch (Throwable ex) {
                    System.err.println("Could not resolve placeholder '" + placeholder + "' in [" + text + "] as system property: " + ex);
                }
                startIndex = buf.indexOf(PLACEHOLDER_PREFIX, nextIndex);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }

    private String resolveSystemPropertyPlaceholder(String placeholder) {
        DefaultablePlaceholder dp = new DefaultablePlaceholder(placeholder);
        String value = System.getProperty(dp.placeholder);
        if (value == null) {
            value = System.getenv(dp.placeholder);
        }
        if (value == null) {
            value = dp.defaultValue;
        }
        return value;
    }

    protected String resolvePlaceholder(String placeholder, Properties props, int systemPropertiesMode) {
        DefaultablePlaceholder dp = new DefaultablePlaceholder(placeholder);
        String propVal = null;
        if (systemPropertiesMode == 2) {
            propVal = this.resolveSystemProperty(dp.placeholder);
        }
        if (propVal == null) {
            Properties localProperties = propertiesLocal.get();
            propVal = this.resolvePlaceholder(dp.placeholder, localProperties);
        }
        if (propVal == null) {
            propVal = this.resolvePlaceholder(dp.placeholder, props);
        }
        if (propVal == null && systemPropertiesMode == 1) {
            propVal = this.resolveSystemProperty(dp.placeholder);
        }
        if (propVal == null) {
            propVal = dp.defaultValue;
        }
        return PropertyPlaceholderConfigurer.trimToEmpty(propVal);
    }

    private String trimToNull(String str) {
        if (str == null) {
            return null;
        }
        String result = str.trim();
        if (result == null || result.length() == 0) {
            return null;
        }
        return result;
    }

    public static String trimToEmpty(String str) {
        if (str == null) {
            return "";
        }
        return str.trim();
    }

    private static class DefaultablePlaceholder {
        private final String defaultValue;
        private final String placeholder;

        public DefaultablePlaceholder(String placeholder) {
            int commaIndex = placeholder.indexOf(":");
            String defaultValue = null;
            if (commaIndex >= 0) {
                defaultValue = PropertyPlaceholderConfigurer.trimToEmpty(placeholder.substring(commaIndex + 1));
                placeholder = PropertyPlaceholderConfigurer.trimToEmpty(placeholder.substring(0, commaIndex));
            }
            this.placeholder = placeholder;
            this.defaultValue = defaultValue;
        }
    }
}

