/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.config;

import com.navercorp.pinpoint.bootstrap.config.ExcludeMethodFilter;
import com.navercorp.pinpoint.bootstrap.config.ExcludePathFilter;
import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.SkipFilter;
import java.util.Objects;

public class ServerConfig {
    static final String TRACE_REQUEST_PARAM_PROPERTY_NAME = "profiler.server.tracerequestparam";
    static final String HIDE_PINPOINT_HEADER_PROPERTY_NAME = "profiler.server.hidepinpointheader";
    static final String EXCLUDE_URL_PROPERTY_NAME = "profiler.server.excludeurl";
    static final String REAL_IP_HEADER_PROPERTY_NAME = "profiler.server.realipheader";
    static final String REAL_IP_EMPTY_VALUE_PROPERTY_NAME = "profiler.server.realipemptyvalue";
    static final String EXCLUDE_METHOD_PROPERTY_NAME = "profiler.server.excludemethod";
    static final String PRE_EXCLUDE_METHOD_PROPERTY_NAME = "profiler.server.trace.excludemethod";
    private final ProfilerConfig config;

    public ServerConfig(ProfilerConfig config) {
        this.config = Objects.requireNonNull(config, "config");
    }

    public boolean isHidePinpointHeader(String propertyName) {
        Objects.requireNonNull(propertyName, "propertyName");
        String propertyValue = this.config.readString(propertyName, "");
        if (!propertyValue.isEmpty()) {
            return this.config.readBoolean(propertyName, true);
        }
        return this.config.readBoolean(HIDE_PINPOINT_HEADER_PROPERTY_NAME, true);
    }

    public boolean isTraceRequestParam(String propertyName) {
        Objects.requireNonNull(propertyName, "propertyName");
        String propertyValue = this.config.readString(propertyName, "");
        if (!propertyValue.isEmpty()) {
            return this.config.readBoolean(propertyName, true);
        }
        return this.config.readBoolean(TRACE_REQUEST_PARAM_PROPERTY_NAME, true);
    }

    public Filter<String> getExcludeUrlFilter(String propertyName) {
        Objects.requireNonNull(propertyName, "propertyName");
        String excludeUrlPropertyValue = this.config.readString(propertyName, "");
        if (!excludeUrlPropertyValue.isEmpty()) {
            return new ExcludePathFilter(excludeUrlPropertyValue);
        }
        String serverExcludeUrlPropertyValue = this.config.readString(EXCLUDE_URL_PROPERTY_NAME, "");
        if (!serverExcludeUrlPropertyValue.isEmpty()) {
            return new ExcludePathFilter(serverExcludeUrlPropertyValue);
        }
        return new SkipFilter<String>();
    }

    public String getRealIpHeader(String propertyName) {
        Objects.requireNonNull(propertyName, "propertyName");
        String propertyValue = this.config.readString(propertyName, "");
        if (!propertyValue.isEmpty()) {
            return propertyValue;
        }
        return this.config.readString(REAL_IP_HEADER_PROPERTY_NAME, "");
    }

    public String getRealIpEmptyValue(String propertyName) {
        Objects.requireNonNull(propertyName, "propertyName");
        String propertyValue = this.config.readString(propertyName, "");
        if (!propertyValue.isEmpty()) {
            return propertyValue;
        }
        return this.config.readString(REAL_IP_EMPTY_VALUE_PROPERTY_NAME, "");
    }

    public Filter<String> getExcludeMethodFilter(String propertyName) {
        return this.getStringFilter(propertyName, EXCLUDE_METHOD_PROPERTY_NAME);
    }

    public Filter<String> getTraceExcludeMethodFilter(String propertyName) {
        return this.getStringFilter(propertyName, PRE_EXCLUDE_METHOD_PROPERTY_NAME);
    }

    private Filter<String> getStringFilter(String propertyName, String fallbackPropertyName) {
        Objects.requireNonNull(propertyName, "propertyName");
        String propertyValue = this.config.readString(propertyName, "");
        if (!propertyValue.isEmpty()) {
            return new ExcludeMethodFilter(propertyValue);
        }
        String serverExcludeUrlPropertyValue = this.config.readString(fallbackPropertyName, "");
        if (!serverExcludeUrlPropertyValue.isEmpty()) {
            return new ExcludeMethodFilter(serverExcludeUrlPropertyValue);
        }
        return new SkipFilter<String>();
    }
}

