/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor.scope;

import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor5;
import com.navercorp.pinpoint.bootstrap.interceptor.ExceptionHandler;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogManager;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogger;
import java.util.Objects;

public class ExceptionHandleScopedInterceptor5
implements AroundInterceptor5 {
    private final PluginLogger logger = PluginLogManager.getLogger(this.getClass());
    private final boolean debugEnabled = this.logger.isDebugEnabled();
    private final AroundInterceptor5 interceptor;
    private final InterceptorScope scope;
    private final ExecutionPolicy policy;
    private final ExceptionHandler exceptionHandler;

    public ExceptionHandleScopedInterceptor5(AroundInterceptor5 interceptor, InterceptorScope scope, ExecutionPolicy policy, ExceptionHandler exceptionHandler) {
        this.interceptor = Objects.requireNonNull(interceptor, "interceptor");
        this.scope = Objects.requireNonNull(scope, "scope");
        this.policy = Objects.requireNonNull(policy, "policy");
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler, "exceptionHandler");
    }

    @Override
    public void before(Object target, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        InterceptorScopeInvocation transaction = this.scope.getCurrentInvocation();
        if (transaction.tryEnter(this.policy)) {
            try {
                this.interceptor.before(target, arg0, arg1, arg2, arg3, arg4);
            }
            catch (Throwable t) {
                this.exceptionHandler.handleException(t);
            }
        } else if (this.debugEnabled) {
            this.logger.debug("tryBefore() returns false: interceptorScopeTransaction: {}, executionPoint: {}. Skip interceptor {}", new Object[]{transaction, this.policy, this.interceptor.getClass()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void after(Object target, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object result, Throwable throwable) {
        InterceptorScopeInvocation transaction = this.scope.getCurrentInvocation();
        if (transaction.canLeave(this.policy)) {
            try {
                this.interceptor.after(target, arg0, arg1, arg2, arg3, arg4, result, throwable);
            }
            catch (Throwable t) {
                this.exceptionHandler.handleException(t);
            }
            finally {
                transaction.leave(this.policy);
            }
        } else if (this.debugEnabled) {
            this.logger.debug("tryAfter() returns false: interceptorScopeTransaction: {}, executionPoint: {}. Skip interceptor {}", new Object[]{transaction, this.policy, this.interceptor.getClass()});
        }
    }
}

