/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.reactor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessorUtils;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogManager;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogger;
import com.navercorp.pinpoint.bootstrap.plugin.reactor.ReactorContextAccessorUtils;

public class FluxAndMonoSubscribeOrReturnInterceptor
implements AroundInterceptor {
    private final PluginLogger logger = PluginLogManager.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();

    @Override
    public void before(Object target, Object[] args) {
    }

    @Override
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if (throwable != null) {
            return;
        }
        if (result == null) {
            return;
        }
        if (this.checkTargetReactorContextAccessor(target, args, result)) {
            return;
        }
        if (this.checkTargetAsyncContextAccessor(target, args, result)) {
            return;
        }
        if (this.checkSubscriberReactorContextAccessor(target, args, result)) {
            return;
        }
    }

    boolean checkTargetReactorContextAccessor(Object target, Object[] args, Object result) {
        AsyncContext asyncContext = ReactorContextAccessorUtils.getAsyncContext(target);
        if (asyncContext != null) {
            this.setReactorContextToResult(asyncContext, result);
            return true;
        }
        return false;
    }

    boolean checkTargetAsyncContextAccessor(Object target, Object[] args, Object result) {
        AsyncContext asyncContext = AsyncContextAccessorUtils.getAsyncContext(target);
        if (asyncContext != null) {
            this.setReactorContextToResult(asyncContext, result);
            return true;
        }
        return false;
    }

    boolean checkSubscriberReactorContextAccessor(Object target, Object[] args, Object result) {
        AsyncContext asyncContext = ReactorContextAccessorUtils.getAsyncContext(args, 0);
        if (asyncContext != null) {
            this.setReactorContextToResult(asyncContext, result);
            return true;
        }
        return false;
    }

    protected void setReactorContextToResult(AsyncContext asyncContext, Object result) {
        ReactorContextAccessorUtils.setAsyncContext(asyncContext, result);
        if (this.isDebug) {
            this.logger.debug("Set reactorContext to result. reactorContext={}", (Object)asyncContext);
        }
    }
}

