/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request;

import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogManager;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogger;
import com.navercorp.pinpoint.bootstrap.plugin.http.HttpStatusCodeRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.proxy.ProxyRequestRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestTraceReader;
import com.navercorp.pinpoint.bootstrap.plugin.request.ServerRequestRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.method.ServletSyncMethodDescriptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.ParameterRecorder;
import com.navercorp.pinpoint.common.trace.ServiceType;
import java.util.Objects;

public class ServletRequestListener<REQ> {
    static final MethodDescriptor SERVLET_SYNC_METHOD_DESCRIPTOR = new ServletSyncMethodDescriptor();
    private final PluginLogger logger = PluginLogManager.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final boolean isTrace = this.logger.isTraceEnabled();
    private final TraceContext traceContext;
    private final ServiceType serviceType;
    private final RequestAdaptor<REQ> requestAdaptor;
    private final Filter<String> excludeUrlFilter;
    private final Filter<String> excludeMethodFilter;
    private final RequestTraceReader<REQ> requestTraceReader;
    private final ServerRequestRecorder<REQ> serverRequestRecorder;
    private final HttpStatusCodeRecorder httpStatusCodeRecorder;
    private final ParameterRecorder<REQ> parameterRecorder;
    private final ProxyRequestRecorder<REQ> proxyRequestRecorder;

    public ServletRequestListener(ServiceType serviceType, TraceContext traceContext, RequestAdaptor<REQ> requestAdaptor, RequestTraceReader<REQ> requestTraceReader, Filter<String> excludeUrlFilter, Filter<String> excludeMethodFilter, ParameterRecorder<REQ> parameterRecorder, ProxyRequestRecorder<REQ> proxyRequestRecorder, ServerRequestRecorder<REQ> serverRequestRecorder, HttpStatusCodeRecorder httpStatusCodeRecorder) {
        this.serviceType = Objects.requireNonNull(serviceType, "serviceType");
        this.traceContext = Objects.requireNonNull(traceContext, "traceContext");
        this.requestAdaptor = Objects.requireNonNull(requestAdaptor, "requestAdaptor");
        this.requestTraceReader = Objects.requireNonNull(requestTraceReader, "requestTraceReader");
        this.proxyRequestRecorder = Objects.requireNonNull(proxyRequestRecorder, "proxyRequestRecorder");
        this.excludeUrlFilter = Objects.requireNonNull(excludeUrlFilter, "excludeUrlFilter");
        this.excludeMethodFilter = Objects.requireNonNull(excludeMethodFilter, "excludeMethodFilter");
        this.parameterRecorder = Objects.requireNonNull(parameterRecorder, "parameterRecorder");
        this.serverRequestRecorder = Objects.requireNonNull(serverRequestRecorder, "serverRequestRecorder");
        this.httpStatusCodeRecorder = Objects.requireNonNull(httpStatusCodeRecorder, "httpStatusCodeRecorder");
        this.traceContext.cacheApi(SERVLET_SYNC_METHOD_DESCRIPTOR);
    }

    public void initialized(REQ request, ServiceType serviceType, MethodDescriptor methodDescriptor) {
        Trace trace;
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(serviceType, "serviceType");
        Objects.requireNonNull(methodDescriptor, "methodDescriptor");
        if (this.isDebug) {
            this.logger.debug("Initialized requestEvent. serviceType={}, methodDescriptor={}", (Object)serviceType, (Object)methodDescriptor);
        }
        if ((trace = this.createTrace(request)) == null) {
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        if (trace.canSampled()) {
            recorder.recordServiceType(serviceType);
            recorder.recordApi(methodDescriptor);
        }
    }

    private Trace createTrace(REQ request) {
        String requestURI = this.requestAdaptor.getRpcName(request);
        if (this.excludeUrlFilter.filter(requestURI)) {
            if (this.isTrace) {
                this.logger.trace("Filter requestURI={}", (Object)requestURI);
            }
            return null;
        }
        String methodName = this.requestAdaptor.getMethodName(request);
        if (this.excludeMethodFilter.filter(methodName)) {
            if (this.isTrace) {
                this.logger.trace("Filter methodName={}", (Object)methodName);
            }
            return null;
        }
        Trace trace = this.requestTraceReader.read(request);
        if (trace.canSampled()) {
            SpanRecorder recorder = trace.getSpanRecorder();
            recorder.recordServiceType(this.serviceType);
            recorder.recordApi(SERVLET_SYNC_METHOD_DESCRIPTOR);
            this.serverRequestRecorder.record(recorder, request);
            this.proxyRequestRecorder.record(recorder, request);
        }
        return trace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyed(REQ request, Throwable throwable, int statusCode) {
        Trace trace;
        if (this.isDebug) {
            this.logger.debug("Destroyed requestEvent. throwable={}, statusCode={}", (Object)throwable, (Object)statusCode);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            return;
        }
        try {
            this.httpStatusCodeRecorder.record(trace.getSpanRecorder(), statusCode);
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            if (trace.canSampled()) {
                recorder.recordException(throwable);
                this.parameterRecorder.record(recorder, request, throwable);
            }
        }
        finally {
            trace.traceBlockEnd();
            this.traceContext.removeTraceObject();
            trace.close();
        }
    }
}

