/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.util;

import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;

public final class ScopeUtils {
    public static final String ASYNC_TRACE_SCOPE = "##ASYNC_TRACE_SCOPE";

    private ScopeUtils() {
    }

    public static void entryAsyncTraceScope(Trace trace) {
        ScopeUtils.entryScope(trace, ASYNC_TRACE_SCOPE);
    }

    public static void entryScope(Trace trace, String scopeName) {
        TraceScope scope = trace.getScope(scopeName);
        if (scope != null) {
            scope.tryEnter();
        }
    }

    public static boolean leaveAsyncTraceScope(Trace trace) {
        return ScopeUtils.leaveScope(trace, ASYNC_TRACE_SCOPE);
    }

    public static boolean leaveScope(Trace trace, String scopeName) {
        TraceScope scope = trace.getScope(scopeName);
        if (scope != null) {
            if (scope.canLeave()) {
                scope.leave();
            } else {
                return false;
            }
        }
        return true;
    }

    public static boolean isAsyncTraceEndScope(Trace trace) {
        return ScopeUtils.isAsyncTraceEndScope(trace, ASYNC_TRACE_SCOPE);
    }

    public static boolean isAsyncTraceEndScope(Trace trace, String scopeName) {
        if (!trace.isAsync()) {
            return false;
        }
        return ScopeUtils.isEndScope(trace, scopeName);
    }

    public static boolean isEndScope(Trace trace, String scopeName) {
        TraceScope scope = trace.getScope(scopeName);
        return scope != null && !scope.isActive();
    }

    public static boolean hasScope(Trace trace, String scopeName) {
        TraceScope scope = trace.getScope(scopeName);
        return scope != null;
    }

    public static boolean addScope(Trace trace, String scopeName) {
        TraceScope oldScope = trace.addScope(scopeName);
        return oldScope == null;
    }
}

