/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.registry.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.AbstractEventListener;
import com.alibaba.nacos.api.naming.listener.Event;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.ConfigService;
import org.apache.eventmesh.registry.NotifyEvent;
import org.apache.eventmesh.registry.QueryInstances;
import org.apache.eventmesh.registry.RegisterServerInfo;
import org.apache.eventmesh.registry.RegistryListener;
import org.apache.eventmesh.registry.RegistryService;
import org.apache.eventmesh.registry.exception.RegistryException;
import org.apache.eventmesh.registry.nacos.NacosRegistryConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosDiscoveryService
implements RegistryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NacosDiscoveryService.class);
    private final AtomicBoolean initFlag = new AtomicBoolean(false);
    private NacosRegistryConfiguration nacosConf;
    private NamingService namingService;
    private final Map<String, Map<RegistryListener, EventListener>> listeners = new HashMap<String, Map<RegistryListener, EventListener>>();
    private static final Executor notifyExecutor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(20), r -> {
        Thread t = new Thread(r);
        t.setName("org.apache.eventmesh.registry.nacos.executor");
        t.setDaemon(true);
        return t;
    }, new ThreadPoolExecutor.DiscardOldestPolicy());
    private final Lock lock = new ReentrantLock();

    public void init() throws RegistryException {
        if (!this.initFlag.compareAndSet(false, true)) {
            return;
        }
        this.nacosConf = (NacosRegistryConfiguration)((Object)ConfigService.getInstance().buildConfigInstance(NacosRegistryConfiguration.class));
        if (this.nacosConf == null) {
            log.info("nacos registry configuration is null");
        }
        Properties properties = this.buildProperties();
        try {
            this.namingService = NacosFactory.createNamingService((Properties)properties);
        }
        catch (NacosException e) {
            log.error("[NacosRegistryService][start] error", (Throwable)e);
            throw new RegistryException(e.getMessage());
        }
    }

    private Properties buildProperties() {
        Properties properties = new Properties();
        if (this.nacosConf == null) {
            return properties;
        }
        properties.setProperty("serverAddr", this.nacosConf.getRegistryAddr());
        properties.setProperty("username", this.nacosConf.getEventMeshRegistryPluginUsername());
        properties.setProperty("password", this.nacosConf.getEventMeshRegistryPluginPassword());
        String endpoint = this.nacosConf.getEndpoint();
        if (Objects.nonNull(endpoint) && endpoint.contains(":")) {
            int index = endpoint.indexOf(":");
            properties.put("endpoint", endpoint.substring(0, index));
            properties.put("endpointPort", endpoint.substring(index + 1));
        } else {
            Optional.ofNullable(endpoint).ifPresent(value -> properties.put("endpoint", endpoint));
            String endpointPort = this.nacosConf.getEndpointPort();
            Optional.ofNullable(endpointPort).ifPresent(value -> properties.put("endpointPort", endpointPort));
        }
        String accessKey = this.nacosConf.getAccessKey();
        Optional.ofNullable(accessKey).ifPresent(value -> properties.put("accessKey", accessKey));
        String secretKey = this.nacosConf.getSecretKey();
        Optional.ofNullable(secretKey).ifPresent(value -> properties.put("secretKey", secretKey));
        String clusterName = this.nacosConf.getClusterName();
        Optional.ofNullable(clusterName).ifPresent(value -> properties.put("clusterName", clusterName));
        String logFileName = this.nacosConf.getLogFileName();
        Optional.ofNullable(logFileName).ifPresent(value -> properties.put("com.alibaba.nacos.naming.log.filename", logFileName));
        String logLevel = this.nacosConf.getLogLevel();
        Optional.ofNullable(logLevel).ifPresent(value -> properties.put("com.alibaba.nacos.naming.log.level", logLevel));
        Integer pollingThreadCount = this.nacosConf.getPollingThreadCount();
        Optional.ofNullable(pollingThreadCount).ifPresent(value -> properties.put("namingPollingThreadCount", pollingThreadCount));
        String namespace = this.nacosConf.getNamespace();
        Optional.ofNullable(namespace).ifPresent(value -> properties.put("namespace", namespace));
        return properties;
    }

    public void shutdown() throws RegistryException {
        if (this.namingService != null) {
            try {
                this.namingService.shutDown();
            }
            catch (NacosException e) {
                log.warn("shutdown nacos naming service fail", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(final RegistryListener listener, String serviceName) {
        this.lock.lock();
        try {
            ServiceInfo serviceInfo = ServiceInfo.fromKey((String)serviceName);
            Map eventListenerMap = this.listeners.computeIfAbsent(serviceName, k -> new HashMap());
            if (eventListenerMap.containsKey(listener)) {
                log.warn("already use same listener subscribe service name {}", (Object)serviceName);
                return;
            }
            AbstractEventListener eventListener = new AbstractEventListener(){

                public Executor getExecutor() {
                    return notifyExecutor;
                }

                public void onEvent(Event event) {
                    if (!(event instanceof NamingEvent)) {
                        log.warn("received notify event type isn't not as expected");
                        return;
                    }
                    try {
                        NamingEvent namingEvent = (NamingEvent)event;
                        List instances = namingEvent.getInstances();
                        ArrayList<RegisterServerInfo> list = new ArrayList<RegisterServerInfo>();
                        if (instances != null) {
                            for (Instance instance : instances) {
                                RegisterServerInfo info = new RegisterServerInfo();
                                info.setAddress(instance.getIp() + ":" + instance.getPort());
                                info.setMetadata(instance.getMetadata());
                                info.setHealth(instance.isHealthy());
                                info.setServiceName(ServiceInfo.getKey((String)NamingUtils.getGroupedName((String)namingEvent.getServiceName(), (String)namingEvent.getGroupName()), (String)namingEvent.getClusters()));
                                list.add(info);
                            }
                        }
                        listener.onChange(new NotifyEvent(list));
                    }
                    catch (Exception e) {
                        log.warn("");
                    }
                }
            };
            List<Object> clusters = serviceInfo.getClusters() == null || serviceInfo.getClusters().isEmpty() ? new ArrayList() : Arrays.stream(serviceInfo.getClusters().split(",")).collect(Collectors.toList());
            this.namingService.subscribe(serviceInfo.getName(), serviceInfo.getGroupName(), clusters, (EventListener)eventListener);
            eventListenerMap.put(listener, eventListener);
        }
        catch (Exception e) {
            log.error("subscribe service name {} fail", (Object)serviceName, (Object)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(RegistryListener registryListener, String serviceName) {
        this.lock.lock();
        try {
            ServiceInfo serviceInfo = ServiceInfo.fromKey((String)serviceName);
            Map<RegistryListener, EventListener> map = this.listeners.get(serviceName);
            if (map == null) {
                return;
            }
            List<Object> clusters = serviceInfo.getClusters() == null || serviceInfo.getClusters().isEmpty() ? new ArrayList() : Arrays.stream(serviceInfo.getClusters().split(",")).collect(Collectors.toList());
            EventListener eventListener = map.get(registryListener);
            this.namingService.unsubscribe(serviceInfo.getName(), serviceInfo.getGroupName(), clusters, eventListener);
            map.remove(registryListener);
        }
        catch (Exception e) {
            log.error("unsubscribe service name {} fail", (Object)serviceName, (Object)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<RegisterServerInfo> selectInstances(QueryInstances queryInstances) {
        ArrayList<RegisterServerInfo> list = new ArrayList<RegisterServerInfo>();
        try {
            List instances;
            ServiceInfo serviceInfo = ServiceInfo.fromKey((String)queryInstances.getServiceName());
            ArrayList<String> clusters = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)serviceInfo.getClusters())) {
                clusters.addAll(Arrays.asList(serviceInfo.getClusters().split(",")));
            }
            if ((instances = this.namingService.selectInstances(serviceInfo.getName(), serviceInfo.getGroupName(), clusters, queryInstances.isHealth())) != null) {
                instances.forEach(x -> {
                    RegisterServerInfo instanceInfo = new RegisterServerInfo();
                    instanceInfo.setMetadata(x.getMetadata());
                    instanceInfo.setHealth(x.isHealthy());
                    instanceInfo.setAddress(x.getIp() + ":" + x.getPort());
                    instanceInfo.setServiceName(ServiceInfo.getKey((String)NamingUtils.getGroupedName((String)x.getServiceName(), (String)serviceInfo.getGroupName()), (String)x.getClusterName()));
                    list.add(instanceInfo);
                });
            }
            return list;
        }
        catch (Exception e) {
            log.error("select instance by query {} from nacos fail", (Object)queryInstances, (Object)e);
            return list;
        }
    }

    public boolean register(RegisterServerInfo eventMeshRegisterInfo) throws RegistryException {
        try {
            String[] ipPort = eventMeshRegisterInfo.getAddress().split(":");
            if (ipPort.length < 2) {
                return false;
            }
            ServiceInfo serviceInfo = ServiceInfo.fromKey((String)eventMeshRegisterInfo.getServiceName());
            Instance instance = new Instance();
            instance.setClusterName(serviceInfo.getClusters());
            instance.setEnabled(true);
            instance.setEphemeral(true);
            instance.setHealthy(eventMeshRegisterInfo.isHealth());
            instance.setWeight(1.0);
            instance.setIp(ipPort[0]);
            instance.setPort(Integer.parseInt(ipPort[1]));
            instance.setMetadata(eventMeshRegisterInfo.getMetadata());
            this.namingService.registerInstance(serviceInfo.getName(), serviceInfo.getGroupName(), instance);
            return true;
        }
        catch (Exception e) {
            log.error("register instance service {} fail", (Object)eventMeshRegisterInfo, (Object)e);
            return false;
        }
    }

    public boolean unRegister(RegisterServerInfo eventMeshRegisterInfo) throws RegistryException {
        try {
            String[] ipPort = eventMeshRegisterInfo.getAddress().split(":");
            if (ipPort.length < 2) {
                return false;
            }
            ServiceInfo serviceInfo = ServiceInfo.fromKey((String)eventMeshRegisterInfo.getServiceName());
            this.namingService.deregisterInstance(serviceInfo.getName(), serviceInfo.getGroupName(), ipPort[0], Integer.parseInt(ipPort[1]), serviceInfo.getClusters());
            return true;
        }
        catch (Exception e) {
            log.error("unregister instance service {} fail", (Object)eventMeshRegisterInfo, (Object)e);
            return false;
        }
    }
}

