/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.config.convert;

import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.ConfigField;
import org.apache.eventmesh.common.config.convert.ConvertInfo;

public interface ConvertValue<T> {
    public T convert(ConvertInfo var1);

    default public boolean canHandleNullValue() {
        return false;
    }

    default public Object processFieldValue(ConvertInfo convertInfo, String key, ConfigField configField) {
        Properties properties = convertInfo.getProperties();
        String value = properties.getProperty(key);
        if (Objects.isNull(value)) {
            return null;
        }
        value = value.trim();
        boolean findEnv = configField.findEnv();
        String fieldName = configField.field();
        if (StringUtils.isBlank((CharSequence)value) && !StringUtils.isBlank((CharSequence)fieldName) && findEnv) {
            value = Optional.ofNullable(System.getProperty(fieldName)).orElse(System.getenv(fieldName));
        }
        if (StringUtils.isBlank((CharSequence)value) && configField.notEmpty()) {
            throw new RuntimeException(key + " can't be empty!");
        }
        return value;
    }

    public static class DefaultConverter
    implements ConvertValue<Object> {
        @Override
        public Object convert(ConvertInfo convertInfo) {
            return null;
        }
    }
}

