/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.file;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.eventmesh.common.file.FileChangeContext;
import org.apache.eventmesh.common.file.FileChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchFileTask
extends Thread {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WatchFileTask.class);
    private static final FileSystem FILE_SYSTEM = FileSystems.getDefault();
    private final transient WatchService watchService;
    private final transient List<FileChangeListener> fileChangeListeners = new ArrayList<FileChangeListener>();
    private volatile transient boolean watch = true;
    private final transient String directoryPath;

    public WatchFileTask(String directoryPath) {
        this.directoryPath = directoryPath;
        Path path = Paths.get(directoryPath, new String[0]);
        if (!path.toFile().exists()) {
            throw new IllegalArgumentException("file directory not exist: " + directoryPath);
        }
        if (!path.toFile().isDirectory()) {
            throw new IllegalArgumentException("must be a file directory : " + directoryPath);
        }
        try {
            this.watchService = FILE_SYSTEM.newWatchService();
        }
        catch (IOException ex) {
            throw new RuntimeException("WatchService initialization fail", ex);
        }
        try {
            path.register(this.watchService, StandardWatchEventKinds.OVERFLOW, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
        }
        catch (IOException ex) {
            try {
                this.watchService.close();
            }
            catch (IOException e) {
                ex.addSuppressed(e);
            }
            throw new UnsupportedOperationException("WatchService registry fail", ex);
        }
    }

    public void addFileChangeListener(FileChangeListener fileChangeListener) {
        if (fileChangeListener != null) {
            this.fileChangeListeners.add(fileChangeListener);
        }
    }

    public void shutdown() {
        this.watch = false;
        try {
            this.watchService.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to close WatchService", e);
        }
    }

    @Override
    public void run() {
        while (this.watch) {
            try {
                WatchKey watchKey = this.watchService.take();
                List<WatchEvent<?>> events = watchKey.pollEvents();
                watchKey.reset();
                if (events.isEmpty()) continue;
                for (WatchEvent<?> event : events) {
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind.equals(StandardWatchEventKinds.OVERFLOW)) {
                        log.warn("[WatchFileTask] file overflow: {}", event.context());
                        continue;
                    }
                    this.precessWatchEvent(event);
                }
            }
            catch (InterruptedException ex) {
                boolean interrupted = Thread.interrupted();
                if (!interrupted) continue;
                log.debug("[WatchFileTask] file watch is interrupted");
            }
            catch (Exception ex) {
                log.error("[WatchFileTask] an exception occurred during file listening : ", (Throwable)ex);
            }
        }
    }

    private void precessWatchEvent(WatchEvent<?> event) {
        try {
            for (FileChangeListener fileChangeListener : this.fileChangeListeners) {
                FileChangeContext context = new FileChangeContext();
                context.setDirectoryPath(this.directoryPath);
                context.setFileName(event.context().toString());
                context.setWatchEvent(event);
                if (!fileChangeListener.support(context)) continue;
                fileChangeListener.onChanged(context);
            }
        }
        catch (Exception ex) {
            log.error("[WatchFileTask] file change event callback error : ", (Throwable)ex);
        }
    }
}

