/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.meta;

import com.alibaba.otter.canal.meta.CanalMetaManager;
import com.alibaba.otter.canal.meta.MemoryMetaManager;
import com.alibaba.otter.canal.meta.ZooKeeperMetaManager;
import com.alibaba.otter.canal.meta.exception.CanalMetaManagerException;
import com.alibaba.otter.canal.protocol.ClientIdentity;
import com.alibaba.otter.canal.protocol.position.Position;
import com.alibaba.otter.canal.protocol.position.PositionRange;
import com.google.common.collect.MigrateMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class PeriodMixedMetaManager
extends MemoryMetaManager
implements CanalMetaManager {
    private static final Logger logger = LoggerFactory.getLogger(PeriodMixedMetaManager.class);
    private ScheduledExecutorService executor;
    private ZooKeeperMetaManager zooKeeperMetaManager;
    private final Position nullCursor = new Position(){};
    private long period = 1000L;
    private Set<ClientIdentity> updateCursorTasks;

    @Override
    public void start() {
        super.start();
        Assert.notNull((Object)this.zooKeeperMetaManager);
        if (!this.zooKeeperMetaManager.isStart()) {
            this.zooKeeperMetaManager.start();
        }
        this.executor = Executors.newScheduledThreadPool(1);
        this.destinations = MigrateMap.makeComputingMap(destination -> this.zooKeeperMetaManager.listAllSubscribeInfo((String)destination));
        this.cursors = MigrateMap.makeComputingMap(clientIdentity -> {
            Position position = this.zooKeeperMetaManager.getCursor((ClientIdentity)clientIdentity);
            if (position == null) {
                return this.nullCursor;
            }
            return position;
        });
        this.batches = MigrateMap.makeComputingMap(clientIdentity -> {
            MemoryMetaManager.MemoryClientIdentityBatch batches = MemoryMetaManager.MemoryClientIdentityBatch.create(clientIdentity);
            Map<Long, PositionRange> positionRanges = this.zooKeeperMetaManager.listAllBatchs((ClientIdentity)clientIdentity);
            for (Map.Entry<Long, PositionRange> entry : positionRanges.entrySet()) {
                batches.addPositionRange(entry.getValue(), entry.getKey());
            }
            return batches;
        });
        this.updateCursorTasks = Collections.synchronizedSet(new HashSet());
        this.executor.scheduleAtFixedRate(() -> {
            ArrayList<ClientIdentity> tasks = new ArrayList<ClientIdentity>(this.updateCursorTasks);
            for (ClientIdentity clientIdentity : tasks) {
                try {
                    this.updateCursorTasks.remove(clientIdentity);
                    this.zooKeeperMetaManager.updateCursor(clientIdentity, this.getCursor(clientIdentity));
                }
                catch (Throwable e) {
                    logger.error("period update" + clientIdentity.toString() + " curosr failed!", e);
                }
            }
        }, this.period, this.period, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        super.stop();
        if (this.zooKeeperMetaManager.isStart()) {
            this.zooKeeperMetaManager.stop();
        }
        this.executor.shutdownNow();
        this.destinations.clear();
        this.batches.clear();
    }

    @Override
    public void subscribe(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        super.subscribe(clientIdentity);
        this.executor.submit(() -> this.zooKeeperMetaManager.subscribe(clientIdentity));
    }

    @Override
    public void unsubscribe(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        super.unsubscribe(clientIdentity);
        this.executor.submit(() -> this.zooKeeperMetaManager.unsubscribe(clientIdentity));
    }

    @Override
    public void updateCursor(ClientIdentity clientIdentity, Position position) throws CanalMetaManagerException {
        super.updateCursor(clientIdentity, position);
        this.updateCursorTasks.add(clientIdentity);
    }

    @Override
    public Position getCursor(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        Position position = super.getCursor(clientIdentity);
        if (position == this.nullCursor) {
            return null;
        }
        return position;
    }

    public void setZooKeeperMetaManager(ZooKeeperMetaManager zooKeeperMetaManager) {
        this.zooKeeperMetaManager = zooKeeperMetaManager;
    }

    public void setPeriod(long period) {
        this.period = period;
    }
}

