/*
 * Decompiled with CFR 0.152.
 */
package jodd.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import jodd.util.StringPool;

public class StreamGobbler
extends Thread {
    protected final InputStream is;
    protected final String prefix;
    protected final OutputStream out;
    protected final Object lock = new Object();
    protected boolean end = false;

    public StreamGobbler(InputStream is) {
        this(is, null, null);
    }

    public StreamGobbler(InputStream is, OutputStream output) {
        this(is, output, null);
    }

    public StreamGobbler(InputStream is, OutputStream output, String prefix) {
        this.is = is;
        this.prefix = prefix;
        this.out = output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStreamReader isr = new InputStreamReader(this.is);
        try (BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                if (this.out == null) continue;
                if (this.prefix != null) {
                    this.out.write(this.prefix.getBytes());
                }
                this.out.write(line.getBytes());
                this.out.write(StringPool.BYTES_NEW_LINE);
            }
        }
        catch (IOException ioe) {
            if (this.out != null) {
                ioe.printStackTrace(new PrintStream(this.out));
            }
        }
        finally {
            if (this.out != null) {
                try {
                    this.out.flush();
                }
                catch (IOException iOException) {}
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
            this.end = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (!this.end) {
                    this.lock.wait();
                }
            }
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
    }
}

