/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.session.retry;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.eventmesh.common.protocol.SubscriptionType;
import org.apache.eventmesh.retry.api.AbstractRetryer;
import org.apache.eventmesh.retry.api.timer.TimerTask;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.RetryContext;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push.DownStreamMsgContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpRetryer
extends AbstractRetryer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TcpRetryer.class);
    private EventMeshTCPServer eventMeshTCPServer;

    public TcpRetryer(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    public EventMeshTCPServer getEventMeshTCPServer() {
        return this.eventMeshTCPServer;
    }

    public void setEventMeshTCPServer(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    public void newTimeout(TimerTask timerTask, long delay, TimeUnit timeUnit) {
        RetryContext retryContext = (RetryContext)timerTask;
        int maxRetryTimes = this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshTcpMsgAsyncRetryTimes();
        if (retryContext instanceof DownStreamMsgContext) {
            DownStreamMsgContext downStreamMsgContext = (DownStreamMsgContext)retryContext;
            int n = maxRetryTimes = SubscriptionType.SYNC == downStreamMsgContext.getSubscriptionItem().getType() ? this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshTcpMsgSyncRetryTimes() : this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshTcpMsgAsyncRetryTimes();
        }
        if (retryContext.retryTimes >= maxRetryTimes) {
            log.warn("pushRetry fail,retry over maxRetryTimes:{}, retryTimes:{}, seq:{}, bizSeq:{}", new Object[]{maxRetryTimes, retryContext.retryTimes, retryContext.seq, EventMeshUtil.getMessageBizSeq(retryContext.event)});
            return;
        }
        super.newTimeout(timerTask, delay, timeUnit);
        log.info("pushRetry success,seq:{}, retryTimes:{}, bizSeq:{}", new Object[]{retryContext.seq, retryContext.retryTimes, EventMeshUtil.getMessageBizSeq(retryContext.event)});
    }
}

