/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send;

import io.cloudevents.CloudEvent;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.runtime.core.protocol.RetryContext;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientGroupWrapper;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.EventMeshTcpSendResult;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.EventMeshTcpSendStatus;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpStreamMsgContext
extends RetryContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpStreamMsgContext.class);
    private final Session session;
    private final long createTime = System.currentTimeMillis();
    private final Header header;
    private final long startTime;
    private final long taskExecuteTime;

    public UpStreamMsgContext(Session session, CloudEvent event, Header header, long startTime, long taskExecuteTime) {
        this.seq = header.getSeq();
        this.session = session;
        this.event = event;
        this.header = header;
        this.startTime = startTime;
        this.taskExecuteTime = taskExecuteTime;
    }

    public Session getSession() {
        return this.session;
    }

    public CloudEvent getEvent() {
        return this.event;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public String toString() {
        return "UpStreamMsgContext{seq=" + this.seq + ",topic=" + this.event.getSubject() + ",client=" + this.session.getClient() + ",retryTimes=" + this.retryTimes + ",createTime=" + DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + "},executeTime=" + DateFormatUtils.format((long)this.executeTime, (String)"yyyy-MM-dd HH:mm:ss.SSS");
    }

    public void retry() {
        block3: {
            log.info("retry upStream msg start,seq:{},retryTimes:{},bizSeq:{}", new Object[]{this.seq, this.retryTimes, EventMeshUtil.getMessageBizSeq(this.event)});
            try {
                Command replyCmd = this.getReplyCmd(this.header.getCmd());
                long sendTime = System.currentTimeMillis();
                ++this.retryTimes;
                if (!this.session.isRunning()) break block3;
                EventMeshTcpSendResult sendStatus = this.session.upstreamMsg(this.header, this.event, this.createSendCallback(replyCmd, this.taskExecuteTime, this.event, this), this.startTime, this.taskExecuteTime);
                if (StringUtils.equals((CharSequence)EventMeshTcpSendStatus.SUCCESS.name(), (CharSequence)sendStatus.getSendStatus().name())) {
                    log.info("pkg|eventMesh2mq|cmd={}|event={}|user={}|wait={}ms|cost={}ms", new Object[]{this.header.getCmd(), this.event, this.session.getClient(), this.taskExecuteTime - this.startTime, sendTime - this.startTime});
                    break block3;
                }
                throw new Exception(sendStatus.getDetail());
            }
            catch (Exception e) {
                log.error("TCP UpstreamMsg Retry error", (Throwable)e);
            }
        }
    }

    protected SendCallback createSendCallback(final Command replyCmd, final long taskExecuteTime, final CloudEvent event, final UpStreamMsgContext retryContext) {
        final long createTime = System.currentTimeMillis();
        final Package msg = new Package();
        return new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                UpStreamMsgContext.this.session.getSender().getUpstreamBuff().release();
                log.info("upstreamMsg message success|user={}|callback cost={}", (Object)UpStreamMsgContext.this.session.getClient(), (Object)(System.currentTimeMillis() - createTime));
                if (replyCmd == Command.BROADCAST_MESSAGE_TO_SERVER_ACK || replyCmd == Command.ASYNC_MESSAGE_TO_SERVER_ACK) {
                    msg.setHeader(new Header(replyCmd, OPStatus.SUCCESS.getCode().intValue(), OPStatus.SUCCESS.getDesc(), UpStreamMsgContext.this.seq));
                    msg.setBody((Object)event);
                    Utils.writeAndFlush(msg, UpStreamMsgContext.this.startTime, taskExecuteTime, UpStreamMsgContext.this.session.getContext(), UpStreamMsgContext.this.session);
                }
            }

            public void onException(OnExceptionContext context) {
                UpStreamMsgContext.this.session.getSender().getUpstreamBuff().release();
                Objects.requireNonNull((ClientGroupWrapper)UpStreamMsgContext.this.session.getClientGroupWrapper().get()).getTcpRetryer().newTimeout(retryContext, 10L, TimeUnit.SECONDS);
                UpStreamMsgContext.this.session.getSender().getFailMsgCount().incrementAndGet();
                log.error("upstreamMsg mq message error|user={}|callback cost={}, errMsg={}", new Object[]{UpStreamMsgContext.this.session.getClient(), System.currentTimeMillis() - createTime, new Exception((Throwable)context.getException())});
                msg.setHeader(new Header(replyCmd, OPStatus.FAIL.getCode().intValue(), context.getException().toString(), UpStreamMsgContext.this.seq));
                msg.setBody((Object)event);
                Utils.writeAndFlush(msg, UpStreamMsgContext.this.startTime, taskExecuteTime, UpStreamMsgContext.this.session.getContext(), UpStreamMsgContext.this.session);
            }
        };
    }

    private Command getReplyCmd(Command cmd) {
        switch (cmd) {
            case REQUEST_TO_SERVER: {
                return Command.RESPONSE_TO_CLIENT;
            }
            case ASYNC_MESSAGE_TO_SERVER: {
                return Command.ASYNC_MESSAGE_TO_SERVER_ACK;
            }
            case BROADCAST_MESSAGE_TO_SERVER: {
                return Command.BROADCAST_MESSAGE_TO_SERVER_ACK;
            }
        }
        return cmd;
    }

    @Override
    public void doRun() throws Exception {
        this.retry();
    }
}

