/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.http.sink.data;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.eventmesh.connector.http.sink.data.HttpAttemptEvent;

public class MultiHttpRequestContext {
    public static final String NAME = "multi-http-request-context";
    private final AtomicInteger remainingRequests;
    private HttpAttemptEvent lastFailedEvent;

    public MultiHttpRequestContext(int remainingEvents) {
        this.remainingRequests = new AtomicInteger(remainingEvents);
    }

    public void decrementRemainingRequests() {
        this.remainingRequests.decrementAndGet();
    }

    public boolean isAllRequestsProcessed() {
        return this.remainingRequests.get() == 0;
    }

    public int getRemainingRequests() {
        return this.remainingRequests.get();
    }

    public HttpAttemptEvent getLastFailedEvent() {
        return this.lastFailedEvent;
    }

    public void setLastFailedEvent(HttpAttemptEvent lastFailedEvent) {
        this.lastFailedEvent = lastFailedEvent;
    }
}

