/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.common.zookeeper;

import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;

public class ZookeeperPathUtils {
    public static final String ZOOKEEPER_SEPARATOR = "/";
    public static final String OTTER_ROOT_NODE = "/otter";
    public static final String CANAL_ROOT_NODE = "/otter/canal";
    public static final String DESTINATION_ROOT_NODE = "/otter/canal/destinations";
    public static final String FILTER_NODE = "filter";
    public static final String BATCH_MARK_NODE = "mark";
    public static final String PARSE_NODE = "parse";
    public static final String CURSOR_NODE = "cursor";
    public static final String RUNNING_NODE = "running";
    public static final String CLUSTER_NODE = "cluster";
    public static final String DESTINATION_NODE = "/otter/canal/destinations/{0}";
    public static final String DESTINATION_PARSE_NODE = "/otter/canal/destinations/{0}/parse";
    public static final String DESTINATION_CLIENTID_NODE = "/otter/canal/destinations/{0}/{1}";
    public static final String DESTINATION_CURSOR_NODE = "/otter/canal/destinations/{0}/{1}/cursor";
    public static final String DESTINATION_CLIENTID_FILTER_NODE = "/otter/canal/destinations/{0}/{1}/filter";
    public static final String DESTINATION_CLIENTID_BATCH_MARK_NODE = "/otter/canal/destinations/{0}/{1}/mark";
    public static final String DESTINATION_CLIENTID_BATCH_MARK_WITH_ID_PATH = "/otter/canal/destinations/{0}/{1}/mark/{2}";
    public static final String DESTINATION_RUNNING_NODE = "/otter/canal/destinations/{0}/running";
    public static final String DESTINATION_CLIENTID_RUNNING_NODE = "/otter/canal/destinations/{0}/{1}/running";
    public static final String CANAL_CLUSTER_ROOT_NODE = "/otter/canal/cluster";
    public static final String CANAL_CLUSTER_NODE = "/otter/canal/cluster/{0}";
    public static final String DESTINATION_CLUSTER_ROOT = "/otter/canal/destinations/{0}/cluster";
    public static final String DESTINATION_CLUSTER_NODE = "/otter/canal/destinations/{0}/cluster/{1}";

    public static String getDestinationPath(String destinationName) {
        return MessageFormat.format(DESTINATION_NODE, destinationName);
    }

    public static String getClientIdNodePath(String destinationName, short clientId) {
        return MessageFormat.format(DESTINATION_CLIENTID_NODE, destinationName, String.valueOf(clientId));
    }

    public static String getFilterPath(String destinationName, short clientId) {
        return MessageFormat.format(DESTINATION_CLIENTID_FILTER_NODE, destinationName, String.valueOf(clientId));
    }

    public static String getBatchMarkPath(String destinationName, short clientId) {
        return MessageFormat.format(DESTINATION_CLIENTID_BATCH_MARK_NODE, destinationName, String.valueOf(clientId));
    }

    public static String getBatchMarkWithIdPath(String destinationName, short clientId, Long batchId) {
        return MessageFormat.format(DESTINATION_CLIENTID_BATCH_MARK_WITH_ID_PATH, destinationName, String.valueOf(clientId), ZookeeperPathUtils.getBatchMarkNode(batchId));
    }

    public static String getCursorPath(String destination, short clientId) {
        return MessageFormat.format(DESTINATION_CURSOR_NODE, destination, String.valueOf(clientId));
    }

    public static String getCanalClusterNode(String node) {
        return MessageFormat.format(CANAL_CLUSTER_NODE, node);
    }

    public static String getDestinationServerRunning(String destination) {
        return MessageFormat.format(DESTINATION_RUNNING_NODE, destination);
    }

    public static String getDestinationClientRunning(String destination, short clientId) {
        return MessageFormat.format(DESTINATION_CLIENTID_RUNNING_NODE, destination, String.valueOf(clientId));
    }

    public static String getDestinationClusterNode(String destination, String node) {
        return MessageFormat.format(DESTINATION_CLUSTER_NODE, destination, node);
    }

    public static String getDestinationClusterRoot(String destination) {
        return MessageFormat.format(DESTINATION_CLUSTER_ROOT, destination);
    }

    public static String getParsePath(String destination) {
        return MessageFormat.format(DESTINATION_PARSE_NODE, destination);
    }

    public static short getClientId(String clientNode) {
        return Short.valueOf(clientNode);
    }

    public static long getBatchMarkId(String batchMarkNode) {
        return Long.valueOf(batchMarkNode);
    }

    public static String getBatchMarkNode(Long batchId) {
        return StringUtils.leftPad((String)String.valueOf(batchId.intValue()), (int)10, (char)'0');
    }
}

