/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.exception.model;

import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionContext;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionContextValue;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExceptionWrapperFactory {
    private final int maxDepth;
    private final int maxErrorMessageLength;

    public ExceptionWrapperFactory(int maxDepth, int maxErrorMessageLength) {
        this.maxDepth = maxDepth;
        this.maxErrorMessageLength = maxErrorMessageLength;
    }

    public List<ExceptionWrapper> newExceptionWrappers(ExceptionContext context) {
        if (context == null) {
            return Collections.emptyList();
        }
        return this.traverseAndWrap(context.getContextValue(), context.getExceptionId());
    }

    private List<ExceptionWrapper> traverseAndWrap(ExceptionContextValue topExceptionContextValue, long exceptionId) {
        ArrayList<ExceptionWrapper> exceptionWrappers = new ArrayList<ExceptionWrapper>();
        int depth = 0;
        ExceptionContextValue curr = topExceptionContextValue;
        while (curr.getPrevious() != null) {
            depth = this.addAllExceptionWrappers(exceptionWrappers, curr.getThrowable(), curr.getPrevious().getThrowable(), curr.getStartTime(), exceptionId, depth);
            curr = curr.getPrevious();
        }
        return exceptionWrappers;
    }

    public int addAllExceptionWrappers(List<ExceptionWrapper> exceptionWrappers, Throwable current, Throwable next, long startTime, long exceptionId, int depthOffset) {
        int depth;
        if (current == null) {
            return depthOffset;
        }
        Throwable curr = current;
        for (depth = depthOffset; curr != null && (this.maxDepth == 0 || depth < this.maxDepth) && curr != next; curr = curr.getCause(), ++depth) {
            exceptionWrappers.add(ExceptionWrapper.newException(curr, startTime, exceptionId, depth, this.maxErrorMessageLength));
        }
        return depth;
    }
}

