/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc.config;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.profiler.context.grpc.config.SpanAutoUriGetter;
import com.navercorp.pinpoint.profiler.context.grpc.config.SpanRawUriGetter;
import com.navercorp.pinpoint.profiler.context.grpc.config.SpanTemplateUriGetter;
import com.navercorp.pinpoint.profiler.context.grpc.config.SpanUriGetter;
import java.util.Objects;

public class SpanUriGetterProvider
implements Provider<SpanUriGetter> {
    public static final String SPAN_COLLECTED_URI_CONFIG = "profiler.span.collected.uri.type";
    private final SpanUriType spanCollectedUriType;

    @Inject
    public SpanUriGetterProvider(ProfilerConfig profilerConfig) {
        Objects.requireNonNull(profilerConfig, "profilerConfig");
        this.spanCollectedUriType = SpanUriType.valueOf(profilerConfig.readString(SPAN_COLLECTED_URI_CONFIG, "AUTO"));
    }

    public SpanUriGetter get() {
        switch (this.spanCollectedUriType) {
            case RAW: {
                return new SpanRawUriGetter();
            }
            case TEMPLATE: {
                return new SpanTemplateUriGetter();
            }
        }
        return new SpanAutoUriGetter();
    }

    public static enum SpanUriType {
        TEMPLATE,
        RAW,
        AUTO;

    }
}

