/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.context.ServerMetaDataHolder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcContext;
import com.navercorp.pinpoint.profiler.AgentInformation;
import com.navercorp.pinpoint.profiler.context.DefaultTraceContext;
import com.navercorp.pinpoint.profiler.context.TraceFactory;
import com.navercorp.pinpoint.profiler.context.id.TraceIdFactory;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.StringMetaDataService;
import java.util.Objects;

public class TraceContextProvider
implements Provider<TraceContext> {
    private final ProfilerConfig profilerConfig;
    private final Provider<AgentInformation> agentInformationProvider;
    private final TraceIdFactory traceIdFactory;
    private final TraceFactory traceFactory;
    private final ServerMetaDataHolder serverMetaDataHolder;
    private final ApiMetaDataService apiMetaDataService;
    private final StringMetaDataService stringMetaDataService;
    private final SqlMetaDataService sqlMetaDataService;
    private final JdbcContext jdbcContext;

    @Inject
    public TraceContextProvider(ProfilerConfig profilerConfig, Provider<AgentInformation> agentInformationProvider, TraceIdFactory traceIdFactory, TraceFactory traceFactory, ServerMetaDataHolder serverMetaDataHolder, ApiMetaDataService apiMetaDataService, StringMetaDataService stringMetaDataService, SqlMetaDataService sqlMetaDataService, JdbcContext jdbcContext) {
        this.profilerConfig = Objects.requireNonNull(profilerConfig, "profilerConfig");
        this.agentInformationProvider = Objects.requireNonNull(agentInformationProvider, "agentInformationProvider");
        this.traceIdFactory = Objects.requireNonNull(traceIdFactory, "traceIdFactory");
        this.traceFactory = Objects.requireNonNull(traceFactory, "traceFactory");
        this.serverMetaDataHolder = Objects.requireNonNull(serverMetaDataHolder, "serverMetaDataHolder");
        this.apiMetaDataService = Objects.requireNonNull(apiMetaDataService, "apiMetaDataService");
        this.stringMetaDataService = Objects.requireNonNull(stringMetaDataService, "stringMetaDataService");
        this.sqlMetaDataService = Objects.requireNonNull(sqlMetaDataService, "sqlMetaDataService");
        this.jdbcContext = Objects.requireNonNull(jdbcContext, "jdbcContext");
    }

    public TraceContext get() {
        AgentInformation agentInformation = (AgentInformation)this.agentInformationProvider.get();
        return new DefaultTraceContext(this.profilerConfig, agentInformation, this.traceIdFactory, this.traceFactory, this.serverMetaDataHolder, this.apiMetaDataService, this.stringMetaDataService, this.sqlMetaDataService, this.jdbcContext);
    }
}

