/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.stat.response;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.collector.UnsupportedMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.collector.response.DefaultResponseTimeMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.metric.response.ResponseTimeMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.response.ResponseTimeValue;
import java.util.Objects;

public class ResponseTimeMetricCollectorProvider
implements Provider<AgentStatMetricCollector<ResponseTimeValue>> {
    private final ResponseTimeMetric responseTimeMetric;

    @Inject
    public ResponseTimeMetricCollectorProvider(ResponseTimeMetric responseTimeMetric) {
        this.responseTimeMetric = Objects.requireNonNull(responseTimeMetric, "responseTimeMetric");
    }

    public AgentStatMetricCollector<ResponseTimeValue> get() {
        if (this.responseTimeMetric == ResponseTimeMetric.UNSUPPORTED_RESPONSE_TIME_METRIC) {
            return new UnsupportedMetricCollector<ResponseTimeValue>();
        }
        return new DefaultResponseTimeMetricCollector(this.responseTimeMetric);
    }
}

