/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap;

import com.navercorp.pinpoint.bootstrap.AgentIdSourceType;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class AgentProperties {
    private final AgentIdSourceType type;
    private final Properties properties;
    private final String agentIdKey;
    private final String agentNameKey;
    private final String applicationNameKey;

    public AgentProperties(AgentIdSourceType type, Properties properties, String agentIdKey, String agentNameKey, String applicationNameKey) {
        this.type = Objects.requireNonNull(type, "type");
        this.properties = Objects.requireNonNull(properties, "properties");
        this.agentIdKey = Objects.requireNonNull(agentIdKey, "agentIdKey");
        this.agentNameKey = Objects.requireNonNull(agentNameKey, "agentNameKey");
        this.applicationNameKey = Objects.requireNonNull(applicationNameKey, "applicationNameKey");
    }

    public AgentProperties(AgentIdSourceType type, Map<String, String> properties, String agentIdKey, String agentNameKey, String applicationNameKey) {
        this(type, AgentProperties.toProperties(properties), agentIdKey, agentNameKey, applicationNameKey);
    }

    private static Properties toProperties(Map<String, String> properties) {
        Properties copy = new Properties();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            copy.setProperty(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    public AgentIdSourceType getType() {
        return this.type;
    }

    public String getAgentId() {
        return this.trim(this.properties.getProperty(this.agentIdKey));
    }

    public String getAgentName() {
        return this.trim(this.properties.getProperty(this.agentNameKey));
    }

    public String getAgentIdKey() {
        return this.agentIdKey;
    }

    public String getAgentNameKey() {
        return this.agentNameKey;
    }

    public String getApplicationName() {
        return this.trim(this.properties.getProperty(this.applicationNameKey));
    }

    public String getApplicationNameKey() {
        return this.applicationNameKey;
    }

    private String trim(String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AgentProperties{");
        sb.append("type=").append((Object)this.type);
        sb.append(", properties=").append(this.properties);
        sb.append(", agentIdKey='").append(this.agentIdKey).append('\'');
        sb.append(", agentNameKey='").append(this.agentNameKey).append('\'');
        sb.append(", applicationNameKey='").append(this.applicationNameKey).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

