/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.fineract.useradministration.api;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class PasswordPreferencesApiConstants {

    private PasswordPreferencesApiConstants() {

    }

    public static final String RESOURCE_NAME = "passwordpreferences";
    public static final String ENTITY_NAME = "PASSWORD_PREFERENCES";

    // response parameters
    public static final String DESCRIPTION = "description";

    public static final String ACTIVE = "active";

    public static final String ID_PARAM_NAME = "id";

    // request parameters
    public static final String VALIDATION_POLICY_ID = "validationPolicyId";

    static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<>(Arrays.asList(ID_PARAM_NAME, ACTIVE, DESCRIPTION));

}
