/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.GeoReplicationStats;
import com.microsoft.azure.storage.GeoReplicationStatus;
import com.microsoft.azure.storage.ServiceStats;
import com.microsoft.azure.storage.core.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class ServiceStatsHandler
extends DefaultHandler {
    private static final String GEO_REPLICATION_NAME = "GeoReplication";
    private static final String STATUS_NAME = "Status";
    private static final String LAST_SYNC_TIME_NAME = "LastSyncTime";
    private final Stack<String> elementStack = new Stack();
    private StringBuilder bld = new StringBuilder();
    private final GeoReplicationStats geoReplicationStats = new GeoReplicationStats();
    private final ServiceStats stats = new ServiceStats();

    ServiceStatsHandler() {
    }

    public static ServiceStats readServiceStatsFromStream(InputStream inStream) throws ParserConfigurationException, SAXException, IOException {
        SAXParser saxParser = Utility.getSAXParser();
        ServiceStatsHandler handler = new ServiceStatsHandler();
        saxParser.parse(inStream, (DefaultHandler)handler);
        return handler.stats;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elementStack.push(localName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String currentNode = this.elementStack.pop();
        if (!localName.equals(currentNode)) {
            throw new SAXException("The response received is invalid or improperly formatted.");
        }
        String value = this.bld.toString();
        if (value.isEmpty()) {
            value = null;
        }
        if (GEO_REPLICATION_NAME.equals(currentNode)) {
            this.stats.setGeoReplication(this.geoReplicationStats);
        } else if (STATUS_NAME.equals(currentNode)) {
            this.geoReplicationStats.setStatus(GeoReplicationStatus.parse(value));
        } else if (LAST_SYNC_TIME_NAME.equals(currentNode)) {
            try {
                this.geoReplicationStats.setLastSyncTime(Utility.isNullOrEmpty(value) ? null : Utility.parseRFC1123DateFromStringInGMT(value));
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
        }
        this.bld = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.bld.append(ch, start, length);
    }
}

