/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.transformations.StreamExchangeMode;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecDynamicFilteringDataCollector;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecExchange;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecExecutionOrderEnforcer;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ExecNodeGraphProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ProcessorContext;
import org.apache.flink.table.planner.plan.nodes.exec.visitor.AbstractExecNodeExactlyOnceVisitor;
import org.apache.flink.table.types.logical.RowType;

public class DynamicFilteringDependencyProcessor
implements ExecNodeGraphProcessor {
    @Override
    public ExecNodeGraph process(ExecNodeGraph execGraph, ProcessorContext context) {
        ExecNodeGraph factSideProcessedGraph = this.addOrderEnforcer(execGraph, context);
        return this.enforceDimSideBlockingExchange(factSideProcessedGraph, context);
    }

    private ExecNodeGraph addOrderEnforcer(ExecNodeGraph execGraph, ProcessorContext context) {
        final HashMap dynamicFilteringScanDescendants = new HashMap();
        AbstractExecNodeExactlyOnceVisitor dynamicFilteringScanCollector = new AbstractExecNodeExactlyOnceVisitor(){

            @Override
            protected void visitNode(ExecNode<?> node) {
                for (int i = 0; i < node.getInputEdges().size(); ++i) {
                    ExecEdge edge = node.getInputEdges().get(i);
                    ExecNode<?> input = edge.getSource();
                    if (!(input instanceof BatchExecTableSourceScan) || input.getInputEdges().size() <= 0) continue;
                    dynamicFilteringScanDescendants.computeIfAbsent((BatchExecTableSourceScan)input, ignored -> new ArrayList()).add(new DescendantInfo(node, i));
                }
                this.visitInputs(node);
            }
        };
        execGraph.getRootNodes().forEach(node -> node.accept(dynamicFilteringScanCollector));
        for (Map.Entry entry : dynamicFilteringScanDescendants.entrySet()) {
            BatchExecTableSourceScan oldTableSourceScan = (BatchExecTableSourceScan)entry.getKey();
            BatchExecDynamicFilteringDataCollector dynamicFilteringDataCollector = BatchExecTableSourceScan.getDynamicFilteringDataCollector(oldTableSourceScan);
            BatchExecTableSourceScan newTableSourceScan = oldTableSourceScan.copyAndRemoveInputs();
            BatchExecExchange exchange = new BatchExecExchange((ReadableConfig)context.getPlanner().getTableConfig(), InputProperty.builder().requiredDistribution(InputProperty.ANY_DISTRIBUTION).damBehavior(InputProperty.DamBehavior.BLOCKING).build(), (RowType)dynamicFilteringDataCollector.getOutputType(), "Exchange");
            exchange.setRequiredExchangeMode(StreamExchangeMode.BATCH);
            exchange.setInputEdges(Collections.singletonList(ExecEdge.builder().source(dynamicFilteringDataCollector).target(exchange).build()));
            BatchExecExecutionOrderEnforcer enforcer = new BatchExecExecutionOrderEnforcer((ReadableConfig)context.getPlanner().getTableConfig(), Arrays.asList(exchange.getInputProperties().get(0), InputProperty.DEFAULT), newTableSourceScan.getOutputType(), "OrderEnforcer");
            ExecEdge edge1 = ExecEdge.builder().source(exchange).target(enforcer).build();
            ExecEdge edge2 = ExecEdge.builder().source(newTableSourceScan).target(enforcer).build();
            enforcer.setInputEdges(Arrays.asList(edge1, edge2));
            ((List)entry.getValue()).forEach(descendantInfo -> descendantInfo.descendant.replaceInputEdge(descendantInfo.inputId, ExecEdge.builder().source(enforcer).target(descendantInfo.descendant).build()));
        }
        return execGraph;
    }

    private ExecNodeGraph enforceDimSideBlockingExchange(ExecNodeGraph execGraph, final ProcessorContext context) {
        if (context.getPlanner().getTableConfig().getConfiguration().get(ExecutionOptions.BATCH_SHUFFLE_MODE) == BatchShuffleMode.ALL_EXCHANGES_BLOCKING) {
            return execGraph;
        }
        final HashSet nodesRequiredBlockingOutputs = new HashSet();
        AbstractExecNodeExactlyOnceVisitor nodesRequiredBlockingOutputsCollector = new AbstractExecNodeExactlyOnceVisitor(){

            @Override
            protected void visitNode(ExecNode<?> node) {
                if (node instanceof BatchExecDynamicFilteringDataCollector) {
                    nodesRequiredBlockingOutputs.add(node);
                }
                if (nodesRequiredBlockingOutputs.contains(node)) {
                    node.getInputEdges().stream().map(ExecEdge::getSource).forEach(nodesRequiredBlockingOutputs::add);
                }
                this.visitInputs(node);
            }
        };
        execGraph.getRootNodes().forEach(node -> node.accept(nodesRequiredBlockingOutputsCollector));
        AbstractExecNodeExactlyOnceVisitor blockingEnforcerVisitor = new AbstractExecNodeExactlyOnceVisitor(){

            @Override
            protected void visitNode(ExecNode<?> node) {
                this.visitInputs(node);
                if (nodesRequiredBlockingOutputs.contains(node)) {
                    return;
                }
                for (int i = 0; i < node.getInputEdges().size(); ++i) {
                    ExecEdge edge = node.getInputEdges().get(i);
                    ExecNode<?> source = edge.getSource();
                    if (!nodesRequiredBlockingOutputs.contains(source)) continue;
                    if (source instanceof BatchExecExchange) {
                        ((BatchExecExchange)source).setRequiredExchangeMode(StreamExchangeMode.BATCH);
                        continue;
                    }
                    if (node instanceof BatchExecExchange) {
                        ((BatchExecExchange)node).setRequiredExchangeMode(StreamExchangeMode.BATCH);
                        continue;
                    }
                    BatchExecExchange exchange = DynamicFilteringDependencyProcessor.this.createExchange(source, node.getInputProperties().get(i), context.getPlanner().getTableConfig());
                    ExecEdge newEdge = ExecEdge.builder().source(exchange).target(node).build();
                    node.replaceInputEdge(i, newEdge);
                }
            }
        };
        execGraph.getRootNodes().forEach(node -> node.accept(blockingEnforcerVisitor));
        return execGraph;
    }

    private BatchExecExchange createExchange(ExecNode<?> source, InputProperty inputProperty, TableConfig tableConfig) {
        InputProperty newProperty = InputProperty.builder().requiredDistribution(inputProperty.getRequiredDistribution() == InputProperty.UNKNOWN_DISTRIBUTION ? InputProperty.ANY_DISTRIBUTION : inputProperty.getRequiredDistribution()).damBehavior(inputProperty.getDamBehavior()).priority(inputProperty.getPriority()).build();
        BatchExecExchange exchange = new BatchExecExchange((ReadableConfig)tableConfig, newProperty, (RowType)source.getOutputType(), "Exchange");
        exchange.setRequiredExchangeMode(StreamExchangeMode.BATCH);
        ExecEdge execEdge = ExecEdge.builder().source(source).target(exchange).build();
        exchange.setInputEdges(Collections.singletonList(execEdge));
        return exchange;
    }

    private static class DescendantInfo {
        final int inputId;
        final ExecNode<?> descendant;

        DescendantInfo(ExecNode<?> descendant, int inputId) {
            this.descendant = descendant;
            this.inputId = inputId;
        }
    }
}

