/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.typeutils;

import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.LocalTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.NumericTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.table.planner.validate.ValidationFailure;
import org.apache.flink.table.planner.validate.ValidationResult;
import org.apache.flink.table.planner.validate.ValidationSuccess$;
import org.apache.flink.table.runtime.typeutils.BigDecimalTypeInfo;
import org.apache.flink.table.runtime.typeutils.DecimalDataTypeInfo;
import org.apache.flink.table.typeutils.TimeIntervalTypeInfo;

public final class TypeInfoCheckUtils$ {
    public static TypeInfoCheckUtils$ MODULE$;

    static {
        new TypeInfoCheckUtils$();
    }

    public boolean isNumeric(TypeInformation<?> dataType) {
        boolean bl;
        TypeInformation<?> typeInformation = dataType;
        if (typeInformation instanceof NumericTypeInfo) {
            bl = true;
        } else {
            BasicTypeInfo basicTypeInfo = BasicTypeInfo.BIG_DEC_TYPE_INFO;
            TypeInformation<?> typeInformation2 = typeInformation;
            boolean bl2 = !(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null) ? true : (typeInformation instanceof BigDecimalTypeInfo ? true : typeInformation instanceof DecimalDataTypeInfo);
            bl = bl2;
        }
        return bl;
    }

    public boolean isTemporal(TypeInformation<?> dataType) {
        return this.isTimePoint(dataType) || this.isTimeInterval(dataType);
    }

    public boolean isTimePoint(TypeInformation<?> dataType) {
        return dataType instanceof SqlTimeTypeInfo || dataType instanceof LocalTimeTypeInfo;
    }

    public boolean isTimeInterval(TypeInformation<?> dataType) {
        return dataType instanceof TimeIntervalTypeInfo;
    }

    public boolean isArray(TypeInformation<?> dataType) {
        TypeInformation<?> typeInformation = dataType;
        boolean bl = typeInformation instanceof ObjectArrayTypeInfo ? true : (typeInformation instanceof BasicArrayTypeInfo ? true : typeInformation instanceof PrimitiveArrayTypeInfo);
        boolean bl2 = bl;
        return bl2;
    }

    public boolean isMap(TypeInformation<?> dataType) {
        return dataType instanceof MapTypeInfo;
    }

    public ValidationResult assertNumericExpr(TypeInformation<?> dataType, String caller) {
        ValidationResult validationResult;
        TypeInformation<?> typeInformation = dataType;
        if (typeInformation instanceof NumericTypeInfo) {
            validationResult = ValidationSuccess$.MODULE$;
        } else {
            BasicTypeInfo basicTypeInfo = BasicTypeInfo.BIG_DEC_TYPE_INFO;
            TypeInformation<?> typeInformation2 = typeInformation;
            boolean bl = !(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null) ? true : (typeInformation instanceof BigDecimalTypeInfo ? true : typeInformation instanceof DecimalDataTypeInfo);
            validationResult = bl ? ValidationSuccess$.MODULE$ : new ValidationFailure(new StringBuilder(34).append(caller).append(" requires numeric types, get ").append(dataType).append(" here").toString());
        }
        return validationResult;
    }

    public ValidationResult assertOrderableExpr(TypeInformation<?> dataType, String caller) {
        return dataType.isSortKeyType() ? ValidationSuccess$.MODULE$ : new ValidationFailure(new StringBuilder(36).append(caller).append(" requires orderable types, get ").append(dataType).append(" here").toString());
    }

    public boolean isAssignable(Class<?>[] classArray, Class<?>[] toClassArray) {
        if (classArray.length != toClassArray.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (this.isAssignable(classArray[i], toClassArray[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isAssignable(Class<?> cls, Class<?> toClass) {
        if (cls.equals(toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (!toClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(cls)) {
                return Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Long.TYPE.equals(cls)) {
                return Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Boolean.TYPE.equals(cls)) {
                return false;
            }
            if (Double.TYPE.equals(cls)) {
                return false;
            }
            if (Float.TYPE.equals(cls)) {
                return Double.TYPE.equals(toClass);
            }
            if (Character.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Short.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Byte.TYPE.equals(cls)) {
                return Short.TYPE.equals(toClass) || Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            return false;
        }
        return toClass.isAssignableFrom(cls);
    }

    private TypeInfoCheckUtils$() {
        MODULE$ = this;
    }
}

