/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.functions.DefaultOpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.generated.JoinCondition;
import org.apache.flink.table.runtime.operators.join.JoinConditionWithNullFilters;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinInputSideSpec;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinRecordStateView;
import org.apache.flink.table.runtime.operators.join.stream.state.OuterJoinRecordStateView;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.util.IterableIterator;
import org.apache.flink.util.Preconditions;

public abstract class AbstractStreamingJoinOperator
extends AbstractStreamOperator<RowData>
implements TwoInputStreamOperator<RowData, RowData, RowData> {
    private static final long serialVersionUID = -376944622236540545L;
    protected static final String LEFT_RECORDS_STATE_NAME = "left-records";
    protected static final String RIGHT_RECORDS_STATE_NAME = "right-records";
    private final GeneratedJoinCondition generatedJoinCondition;
    protected final InternalTypeInfo<RowData> leftType;
    protected final InternalTypeInfo<RowData> rightType;
    protected final JoinInputSideSpec leftInputSideSpec;
    protected final JoinInputSideSpec rightInputSideSpec;
    private final boolean[] filterNullKeys;
    protected final long leftStateRetentionTime;
    protected final long rightStateRetentionTime;
    protected transient JoinConditionWithNullFilters joinCondition;
    protected transient TimestampedCollector<RowData> collector;

    public AbstractStreamingJoinOperator(InternalTypeInfo<RowData> leftType, InternalTypeInfo<RowData> rightType, GeneratedJoinCondition generatedJoinCondition, JoinInputSideSpec leftInputSideSpec, JoinInputSideSpec rightInputSideSpec, boolean[] filterNullKeys, long leftStateRetentionTime, long rightStateRetentionTime) {
        this.leftType = leftType;
        this.rightType = rightType;
        this.generatedJoinCondition = generatedJoinCondition;
        this.leftInputSideSpec = leftInputSideSpec;
        this.rightInputSideSpec = rightInputSideSpec;
        this.leftStateRetentionTime = leftStateRetentionTime;
        this.rightStateRetentionTime = rightStateRetentionTime;
        this.filterNullKeys = filterNullKeys;
    }

    public void open() throws Exception {
        super.open();
        JoinCondition condition = (JoinCondition)this.generatedJoinCondition.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.joinCondition = new JoinConditionWithNullFilters(condition, this.filterNullKeys, (KeyContext)this);
        this.joinCondition.setRuntimeContext((RuntimeContext)this.getRuntimeContext());
        this.joinCondition.open(DefaultOpenContext.INSTANCE);
        this.collector = new TimestampedCollector(this.output);
    }

    public void close() throws Exception {
        super.close();
        if (this.joinCondition != null) {
            this.joinCondition.close();
        }
    }

    protected static final class OuterRecord {
        public final RowData record;
        public final int numOfAssociations;

        private OuterRecord(RowData record, int numOfAssociations) {
            this.record = record;
            this.numOfAssociations = numOfAssociations;
        }
    }

    private static final class RecordsIterable
    implements IterableIterator<RowData> {
        private final List<OuterRecord> records;
        private int index = 0;

        private RecordsIterable(List<OuterRecord> records) {
            this.records = records;
        }

        public Iterator<RowData> iterator() {
            this.index = 0;
            return this;
        }

        public boolean hasNext() {
            return this.index < this.records.size();
        }

        public RowData next() {
            RowData row = this.records.get((int)this.index).record;
            ++this.index;
            return row;
        }
    }

    protected static final class AssociatedRecords {
        private final List<OuterRecord> records;

        private AssociatedRecords(List<OuterRecord> records) {
            Preconditions.checkNotNull(records);
            this.records = records;
        }

        public boolean isEmpty() {
            return this.records.isEmpty();
        }

        public int size() {
            return this.records.size();
        }

        public Iterable<RowData> getRecords() {
            return new RecordsIterable(this.records);
        }

        public Iterable<OuterRecord> getOuterRecords() {
            return this.records;
        }

        public static AssociatedRecords of(RowData input, boolean inputIsLeft, JoinRecordStateView otherSideStateView, JoinCondition condition) throws Exception {
            ArrayList<OuterRecord> associations = new ArrayList<OuterRecord>();
            if (otherSideStateView instanceof OuterJoinRecordStateView) {
                OuterJoinRecordStateView outerStateView = (OuterJoinRecordStateView)otherSideStateView;
                Iterable<Tuple2<RowData, Integer>> records = outerStateView.getRecordsAndNumOfAssociations();
                for (Tuple2<RowData, Integer> record : records) {
                    boolean matched = inputIsLeft ? condition.apply(input, (RowData)record.f0) : condition.apply((RowData)record.f0, input);
                    if (!matched) continue;
                    associations.add(new OuterRecord((RowData)record.f0, (Integer)record.f1));
                }
            } else {
                Iterable<RowData> records = otherSideStateView.getRecords();
                for (RowData record : records) {
                    boolean matched = inputIsLeft ? condition.apply(input, record) : condition.apply(record, input);
                    if (!matched) continue;
                    associations.add(new OuterRecord(record, -1));
                }
            }
            return new AssociatedRecords(associations);
        }
    }
}

