/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.bridging;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.ContextResolvedProcedure;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.functions.TableAggregateFunctionDefinition;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.inference.TypeInferenceOperandChecker;
import org.apache.flink.table.planner.functions.inference.TypeInferenceOperandInference;
import org.apache.flink.table.planner.functions.inference.TypeInferenceReturnInference;
import org.apache.flink.table.types.inference.TypeInference;

final class BridgingUtils {
    static String createName(ContextResolvedFunction resolvedFunction) {
        return resolvedFunction.getIdentifier().map(BridgingUtils::extractName).orElseGet(() -> BridgingUtils.createInlineFunctionName(resolvedFunction.getDefinition()));
    }

    static String createName(ContextResolvedProcedure resolveProcedure) {
        return BridgingUtils.extractName(resolveProcedure.getIdentifier());
    }

    private static String extractName(FunctionIdentifier identifier) {
        if (identifier.getSimpleName().isPresent()) {
            return (String)identifier.getSimpleName().get();
        }
        return identifier.getIdentifier().map(ObjectIdentifier::getObjectName).orElseThrow(IllegalStateException::new);
    }

    private static String createInlineFunctionName(FunctionDefinition functionDefinition) {
        Optional<UserDefinedFunction> userDefinedFunction = BridgingUtils.extractUserDefinedFunction(functionDefinition);
        return userDefinedFunction.map(UserDefinedFunctionHelper::generateInlineFunctionName).orElseThrow(() -> new TableException(String.format("Unsupported function definition: %s. Only user defined functions are supported as inline functions.", functionDefinition)));
    }

    private static Optional<UserDefinedFunction> extractUserDefinedFunction(FunctionDefinition functionDefinition) {
        if (functionDefinition instanceof UserDefinedFunction) {
            return Optional.of((UserDefinedFunction)functionDefinition);
        }
        if (functionDefinition instanceof ScalarFunctionDefinition) {
            return Optional.ofNullable(((ScalarFunctionDefinition)functionDefinition).getScalarFunction());
        }
        if (functionDefinition instanceof AggregateFunctionDefinition) {
            return Optional.ofNullable(((AggregateFunctionDefinition)functionDefinition).getAggregateFunction());
        }
        if (functionDefinition instanceof TableFunctionDefinition) {
            return Optional.ofNullable(((TableFunctionDefinition)functionDefinition).getTableFunction());
        }
        if (functionDefinition instanceof TableAggregateFunctionDefinition) {
            return Optional.ofNullable(((TableAggregateFunctionDefinition)functionDefinition).getTableAggregateFunction());
        }
        return Optional.empty();
    }

    @Nullable
    static SqlIdentifier createSqlIdentifier(ContextResolvedFunction resolvedFunction) {
        return resolvedFunction.getIdentifier().map(fi -> fi.getIdentifier().map(oi -> new SqlIdentifier(oi.toList(), SqlParserPos.ZERO)).orElseGet(() -> new SqlIdentifier((String)fi.getSimpleName().orElseThrow(IllegalStateException::new), SqlParserPos.ZERO))).orElse(null);
    }

    static SqlIdentifier createSqlIdentifier(ContextResolvedProcedure resolvedProcedure) {
        FunctionIdentifier fi = resolvedProcedure.getIdentifier();
        return fi.getIdentifier().map(oi -> new SqlIdentifier(oi.toList(), SqlParserPos.ZERO)).orElseGet(() -> new SqlIdentifier((String)fi.getSimpleName().orElseThrow(IllegalStateException::new), SqlParserPos.ZERO));
    }

    static SqlReturnTypeInference createSqlReturnTypeInference(DataTypeFactory dataTypeFactory, FunctionDefinition definition, TypeInference typeInference) {
        return new TypeInferenceReturnInference(dataTypeFactory, definition, typeInference);
    }

    static SqlOperandTypeInference createSqlOperandTypeInference(DataTypeFactory dataTypeFactory, FunctionDefinition definition, TypeInference typeInference) {
        return new TypeInferenceOperandInference(dataTypeFactory, definition, typeInference);
    }

    static SqlOperandTypeChecker createSqlOperandTypeChecker(DataTypeFactory dataTypeFactory, FunctionDefinition definition, TypeInference typeInference) {
        return new TypeInferenceOperandChecker(dataTypeFactory, definition, typeInference);
    }

    @Nullable
    static List<RelDataType> createParamTypes(FlinkTypeFactory typeFactory, TypeInference typeInference) {
        return typeInference.getTypedArguments().map(dataTypes -> dataTypes.stream().map(dataType -> typeFactory.createFieldTypeFromLogicalType(dataType.getLogicalType())).collect(Collectors.toList())).orElse(null);
    }

    static SqlFunctionCategory createSqlFunctionCategory(ContextResolvedFunction resolvedFunction) {
        Optional identifier = resolvedFunction.getIdentifier();
        if (!identifier.isPresent() || ((FunctionIdentifier)identifier.get()).getIdentifier().isPresent()) {
            return SqlFunctionCategory.USER_DEFINED_FUNCTION;
        }
        return SqlFunctionCategory.SYSTEM;
    }

    private BridgingUtils() {
    }
}

