/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.LongHashJoinGenerator;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.fusion.OpFusionCodegenSpecGenerator;
import org.apache.flink.table.planner.plan.fusion.generator.TwoInputOpFusionCodegenSpecGenerator;
import org.apache.flink.table.planner.plan.fusion.spec.HashJoinFusionCodegenSpec;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.spec.JoinSpec;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.JoinUtil;
import org.apache.flink.table.planner.plan.utils.SorMergeJoinOperatorUtil;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.HashJoinOperator;
import org.apache.flink.table.runtime.operators.join.HashJoinType;
import org.apache.flink.table.runtime.operators.join.SortMergeJoinFunction;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@ExecNodeMetadata(name="batch-exec-join", version=1, producedTransformations={"join"}, consumedOptions={"table.exec.resource.hash-join.memory", "table.exec.resource.external-buffer-memory", "table.exec.resource.sort.memory", "table.exec.spill-compression.enabled", "table.exec.spill-compression.block-size"}, minPlanVersion=FlinkVersion.v2_0, minStateVersion=FlinkVersion.v2_0)
public class BatchExecHashJoin
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    public static final String JOIN_TRANSFORMATION = "join";
    public static final String FIELD_NAME_JOIN_SPEC = "joinSpec";
    public static final String FIELD_NAME_IS_BROADCAST = "isBroadcast";
    public static final String FIELD_NAME_LEFT_IS_BUILD = "leftIsBuild";
    public static final String FIELD_NAME_ESTIMATED_LEFT_AVG_ROW_SIZE = "estimatedLeftAvgRowSize";
    public static final String FIELD_NAME_ESTIMATED_RIGHT_AVG_ROW_SIZE = "estimatedRightAvgRowSize";
    public static final String FIELD_NAME_ESTIMATED_LEFT_ROW_COUNT = "estimatedLeftRowCount";
    public static final String FIELD_NAME_ESTIMATED_RIGHT_ROW_COUNT = "estimatedRightRowCount";
    public static final String FIELD_NAME_TRY_DISTINCT_BUILD_ROW = "tryDistinctBuildRow";
    @JsonProperty(value="joinSpec")
    private final JoinSpec joinSpec;
    @JsonProperty(value="isBroadcast")
    private final boolean isBroadcast;
    @JsonProperty(value="leftIsBuild")
    private final boolean leftIsBuild;
    @JsonProperty(value="estimatedLeftAvgRowSize")
    private final int estimatedLeftAvgRowSize;
    @JsonProperty(value="estimatedRightAvgRowSize")
    private final int estimatedRightAvgRowSize;
    @JsonProperty(value="estimatedLeftRowCount")
    private final long estimatedLeftRowCount;
    @JsonProperty(value="estimatedRightRowCount")
    private final long estimatedRightRowCount;
    @JsonProperty(value="tryDistinctBuildRow")
    private final boolean tryDistinctBuildRow;

    public BatchExecHashJoin(ReadableConfig tableConfig, JoinSpec joinSpec, int estimatedLeftAvgRowSize, int estimatedRightAvgRowSize, long estimatedLeftRowCount, long estimatedRightRowCount, boolean isBroadcast, boolean leftIsBuild, boolean tryDistinctBuildRow, InputProperty leftInputProperty, InputProperty rightInputProperty, RowType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecHashJoin.class), ExecNodeContext.newPersistedConfig(BatchExecHashJoin.class, tableConfig), Arrays.asList(leftInputProperty, rightInputProperty), (LogicalType)outputType, description);
        this.joinSpec = (JoinSpec)Preconditions.checkNotNull((Object)joinSpec);
        this.isBroadcast = isBroadcast;
        this.leftIsBuild = leftIsBuild;
        this.estimatedLeftAvgRowSize = estimatedLeftAvgRowSize;
        this.estimatedRightAvgRowSize = estimatedRightAvgRowSize;
        this.estimatedLeftRowCount = estimatedLeftRowCount;
        this.estimatedRightRowCount = estimatedRightRowCount;
        this.tryDistinctBuildRow = tryDistinctBuildRow;
    }

    @JsonCreator
    public BatchExecHashJoin(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="joinSpec") JoinSpec joinSpec, @JsonProperty(value="estimatedLeftAvgRowSize") int estimatedLeftAvgRowSize, @JsonProperty(value="estimatedRightAvgRowSize") int estimatedRightAvgRowSize, @JsonProperty(value="estimatedLeftRowCount") long estimatedLeftRowCount, @JsonProperty(value="estimatedRightRowCount") long estimatedRightRowCount, @JsonProperty(value="isBroadcast") boolean isBroadcast, @JsonProperty(value="leftIsBuild") boolean leftIsBuild, @JsonProperty(value="tryDistinctBuildRow") boolean tryDistinctBuildRow, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 2 ? 1 : 0) != 0);
        this.joinSpec = (JoinSpec)Preconditions.checkNotNull((Object)joinSpec);
        this.isBroadcast = isBroadcast;
        this.leftIsBuild = leftIsBuild;
        this.estimatedLeftAvgRowSize = estimatedLeftAvgRowSize;
        this.estimatedRightAvgRowSize = estimatedRightAvgRowSize;
        this.estimatedLeftRowCount = estimatedLeftRowCount;
        this.estimatedRightRowCount = estimatedRightRowCount;
        this.tryDistinctBuildRow = tryDistinctBuildRow;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        int[] probeKeys;
        long probeRowCount;
        RowType probeType;
        GeneratedProjection probeProj;
        Transformation<?> probeTransform;
        int[] buildKeys;
        long buildRowCount;
        int buildRowSize;
        RowType buildType;
        GeneratedProjection buildProj;
        Transformation<?> buildTransform;
        boolean reverseJoin;
        ExecEdge leftInputEdge = this.getInputEdges().get(0);
        ExecEdge rightInputEdge = this.getInputEdges().get(1);
        Transformation<?> leftInputTransform = leftInputEdge.translateToPlan(planner);
        Transformation<?> rightInputTransform = rightInputEdge.translateToPlan(planner);
        RowType leftType = (RowType)leftInputEdge.getOutputType();
        RowType rightType = (RowType)rightInputEdge.getOutputType();
        JoinUtil.validateJoinSpec(this.joinSpec, leftType, rightType, false);
        int[] leftKeys = this.joinSpec.getLeftKeys();
        int[] rightKeys = this.joinSpec.getRightKeys();
        LogicalType[] keyFieldTypes = (LogicalType[])IntStream.of(leftKeys).mapToObj(arg_0 -> ((RowType)leftType).getTypeAt(arg_0)).toArray(LogicalType[]::new);
        RowType keyType = RowType.of((LogicalType[])keyFieldTypes);
        GeneratedJoinCondition condFunc = JoinUtil.generateConditionFunction((ReadableConfig)config, planner.getFlinkContext().getClassLoader(), this.joinSpec.getNonEquiCondition().orElse(null), (LogicalType)leftType, (LogicalType)rightType);
        GeneratedProjection leftProj = ProjectionCodeGenerator.generateProjection(new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader()), "HashJoinLeftProjection", leftType, keyType, leftKeys);
        GeneratedProjection rightProj = ProjectionCodeGenerator.generateProjection(new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader()), "HashJoinRightProjection", rightType, keyType, rightKeys);
        boolean bl = reverseJoin = !this.leftIsBuild;
        if (this.leftIsBuild) {
            buildTransform = leftInputTransform;
            buildProj = leftProj;
            buildType = leftType;
            buildRowSize = this.estimatedLeftAvgRowSize;
            buildRowCount = this.estimatedLeftRowCount;
            buildKeys = leftKeys;
            probeTransform = rightInputTransform;
            probeProj = rightProj;
            probeType = rightType;
            probeRowCount = this.estimatedRightRowCount;
            probeKeys = rightKeys;
        } else {
            buildTransform = rightInputTransform;
            buildProj = rightProj;
            buildType = rightType;
            buildRowSize = this.estimatedRightAvgRowSize;
            buildRowCount = this.estimatedRightRowCount;
            buildKeys = rightKeys;
            probeTransform = leftInputTransform;
            probeProj = leftProj;
            probeType = leftType;
            probeRowCount = this.estimatedLeftRowCount;
            probeKeys = leftKeys;
        }
        FlinkJoinType joinType = this.joinSpec.getJoinType();
        HashJoinType hashJoinType = HashJoinType.of((boolean)this.leftIsBuild, (boolean)joinType.isLeftOuter(), (boolean)joinType.isRightOuter(), (joinType == FlinkJoinType.SEMI ? 1 : 0) != 0, (joinType == FlinkJoinType.ANTI ? 1 : 0) != 0);
        long externalBufferMemory = ((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_EXTERNAL_BUFFER_MEMORY)).getBytes();
        long managedMemory = this.getLargeManagedMemory(joinType, config);
        SortMergeJoinFunction sortMergeJoinFunction = SorMergeJoinOperatorUtil.getSortMergeJoinFunction(planner.getFlinkContext().getClassLoader(), config, joinType, leftType, rightType, leftKeys, rightKeys, keyType, this.leftIsBuild, this.joinSpec.getFilterNulls(), condFunc, 1.0 * (double)externalBufferMemory / (double)managedMemory);
        boolean compressionEnabled = (Boolean)config.get(ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_ENABLED);
        int compressionBlockSize = (int)((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_BLOCK_SIZE)).getBytes();
        SimpleOperatorFactory operator = LongHashJoinGenerator.support(hashJoinType, keyType, this.joinSpec.getFilterNulls()) ? LongHashJoinGenerator.gen(config, planner.getFlinkContext().getClassLoader(), hashJoinType, keyType, buildType, probeType, buildKeys, probeKeys, buildRowSize, buildRowCount, reverseJoin, condFunc, this.leftIsBuild, compressionEnabled, compressionBlockSize, sortMergeJoinFunction) : SimpleOperatorFactory.of((StreamOperator)HashJoinOperator.newHashJoinOperator((HashJoinType)hashJoinType, (boolean)this.leftIsBuild, (boolean)compressionEnabled, (int)compressionBlockSize, (GeneratedJoinCondition)condFunc, (boolean)reverseJoin, (boolean[])this.joinSpec.getFilterNulls(), (GeneratedProjection)buildProj, (GeneratedProjection)probeProj, (boolean)this.tryDistinctBuildRow, (int)buildRowSize, (long)buildRowCount, (long)probeRowCount, (RowType)keyType, (SortMergeJoinFunction)sortMergeJoinFunction));
        return ExecNodeUtil.createTwoInputTransformation(buildTransform, probeTransform, this.createTransformationMeta(JOIN_TRANSFORMATION, config), operator, InternalTypeInfo.of((LogicalType)this.getOutputType()), probeTransform.getParallelism(), managedMemory, false);
    }

    private long getLargeManagedMemory(FlinkJoinType joinType, ExecNodeConfig config) {
        long hashJoinManagedMemory = ((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_HASH_JOIN_MEMORY)).getBytes();
        long externalBufferMemory = ((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_EXTERNAL_BUFFER_MEMORY)).getBytes();
        long sortMemory = ((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_SORT_MEMORY)).getBytes();
        int externalBufferNum = 1;
        if (joinType == FlinkJoinType.FULL) {
            externalBufferNum = 2;
        }
        long sortMergeJoinManagedMemory = externalBufferMemory * (long)externalBufferNum + sortMemory * 2L;
        return Math.max(hashJoinManagedMemory, sortMergeJoinManagedMemory);
    }

    @Override
    public boolean supportFusionCodegen() {
        RowType leftType = (RowType)this.getInputEdges().get(0).getOutputType();
        LogicalType[] keyFieldTypes = (LogicalType[])IntStream.of(this.joinSpec.getLeftKeys()).mapToObj(arg_0 -> ((RowType)leftType).getTypeAt(arg_0)).toArray(LogicalType[]::new);
        RowType keyType = RowType.of((LogicalType[])keyFieldTypes);
        FlinkJoinType joinType = this.joinSpec.getJoinType();
        HashJoinType hashJoinType = HashJoinType.of((boolean)this.leftIsBuild, (boolean)joinType.isLeftOuter(), (boolean)joinType.isRightOuter(), (joinType == FlinkJoinType.SEMI ? 1 : 0) != 0, (joinType == FlinkJoinType.ANTI ? 1 : 0) != 0);
        return LongHashJoinGenerator.support(hashJoinType, keyType, this.joinSpec.getFilterNulls());
    }

    @Override
    protected OpFusionCodegenSpecGenerator translateToFusionCodegenSpecInternal(PlannerBase planner, ExecNodeConfig config, CodeGeneratorContext parentCtx) {
        OpFusionCodegenSpecGenerator leftInput = this.getInputEdges().get(0).translateToFusionCodegenSpec(planner, parentCtx);
        OpFusionCodegenSpecGenerator rightInput = this.getInputEdges().get(1).translateToFusionCodegenSpec(planner, parentCtx);
        boolean compressionEnabled = (Boolean)config.get(ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_ENABLED);
        int compressionBlockSize = (int)((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_SPILL_COMPRESSION_BLOCK_SIZE)).getBytes();
        long managedMemory = this.getLargeManagedMemory(this.joinSpec.getJoinType(), config);
        TwoInputOpFusionCodegenSpecGenerator hashJoinGenerator = new TwoInputOpFusionCodegenSpecGenerator(leftInput, rightInput, managedMemory, (RowType)this.getOutputType(), new HashJoinFusionCodegenSpec(new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader(), parentCtx), this.isBroadcast, this.leftIsBuild, this.joinSpec, this.estimatedLeftAvgRowSize, this.estimatedRightAvgRowSize, this.estimatedLeftRowCount, this.estimatedRightRowCount, compressionEnabled, compressionBlockSize));
        leftInput.addOutput(1, hashJoinGenerator);
        rightInput.addOutput(2, hashJoinGenerator);
        return hashJoinGenerator;
    }
}

