/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.batch;

import java.io.Serializable;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.hint.JoinStrategy;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalLocalHashAggregate;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchPhysicalJoinRuleBase$;
import org.apache.flink.table.planner.plan.utils.JoinUtil$;
import org.apache.flink.table.planner.plan.utils.OperatorType;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005-daB\u0001\u0003!\u0003\r\t!\u0006\u0002\u001a\u0005\u0006$8\r\u001b)isNL7-\u00197K_&t'+\u001e7f\u0005\u0006\u001cXM\u0003\u0002\u0004\t\u0005)!-\u0019;dQ*\u0011QAB\u0001\ta\"L8/[2bY*\u0011q\u0001C\u0001\u0006eVdWm\u001d\u0006\u0003\u0013)\tA\u0001\u001d7b]*\u00111\u0002D\u0001\ba2\fgN\\3s\u0015\tia\"A\u0003uC\ndWM\u0003\u0002\u0010!\u0005)a\r\\5oW*\u0011\u0011CE\u0001\u0007CB\f7\r[3\u000b\u0003M\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019!\u0013N\\5uIQ\tq\u0004\u0005\u0002\u0018A%\u0011\u0011\u0005\u0007\u0002\u0005+:LG\u000fC\u0003$\u0001\u0011EA%\u0001\ndC:,6/\u001a&pS:\u001cFO]1uK\u001eLH\u0003B\u0013)iq\u0002\"a\u0006\u0014\n\u0005\u001dB\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006S\t\u0002\rAK\u0001\u0005U>Lg\u000e\u0005\u0002,e5\tAF\u0003\u0002.]\u0005!1m\u001c:f\u0015\ty\u0003'A\u0002sK2T!!\r\t\u0002\u000f\r\fGnY5uK&\u00111\u0007\f\u0002\u0005\u0015>Lg\u000eC\u00036E\u0001\u0007a'A\u0006uC\ndWmQ8oM&<\u0007CA\u001c;\u001b\u0005A$BA\u001d\r\u0003\r\t\u0007/[\u0005\u0003wa\u00121\u0002V1cY\u0016\u001cuN\u001c4jO\")QH\ta\u0001}\u0005a!n\\5o'R\u0014\u0018\r^3hsB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011IC\u0001\u0005Q&tG/\u0003\u0002D\u0001\na!j\\5o'R\u0014\u0018\r^3hs\")Q\t\u0001C\u0001\r\u0006\u0019\u0012\r\u001a3M_\u000e\fG\u000eR5ti&t7\r^!hOR\u0019qiS'\u0011\u0005!KU\"\u0001\u0018\n\u0005)s#a\u0002*fY:{G-\u001a\u0005\u0006\u0019\u0012\u0003\raR\u0001\u0005]>$W\rC\u0003O\t\u0002\u0007q*\u0001\u0007eSN$\u0018N\\2u\u0017\u0016L8\u000fE\u0002Q1ns!!\u0015,\u000f\u0005I+V\"A*\u000b\u0005Q#\u0012A\u0002\u001fs_>$h(C\u0001\u001a\u0013\t9\u0006$A\u0004qC\u000e\\\u0017mZ3\n\u0005eS&aA*fc*\u0011q\u000b\u0007\t\u0003/qK!!\u0018\r\u0003\u0007%sG\u000fC\u0003`\u0001\u0011\u0005\u0001-A\fdQ>|7/Z*f[&\u0014U/\u001b7e\t&\u001cH/\u001b8diR\u0019Q%Y2\t\u000b\tt\u0006\u0019A$\u0002\u0011\t,\u0018\u000e\u001c3SK2DQA\u00140A\u0002=CQ!\u001a\u0001\u0005\u0012\u0019\fQcZ3u\r&\u00148\u000f\u001e,bY&$'j\\5o\u0011&tG\u000fF\u0002hU.\u00042a\u00065?\u0013\tI\u0007D\u0001\u0004PaRLwN\u001c\u0005\u0006S\u0011\u0004\rA\u000b\u0005\u0006k\u0011\u0004\rA\u000e\u0005\u0006[\u0002!\tA\\\u0001\u0017G\",7m\u001b&pS:\u001cFO]1uK\u001eLh+\u00197jIR)qN]:umB!q\u0003]\u0013&\u0013\t\t\bD\u0001\u0004UkBdWM\r\u0005\u0006S1\u0004\rA\u000b\u0005\u0006k1\u0004\rA\u000e\u0005\u0006k2\u0004\rAP\u0001\u0012iJLW\r\u001a&pS:\u001cFO]1uK\u001eL\b\"B<m\u0001\u0004)\u0013\u0001C<ji\"D\u0015N\u001c;\t\u000be\u0004A\u0011\u0002>\u0002\u0017%\u001cX)];jm*{\u0017N\u001c\u000b\u0003KmDQ!\u000b=A\u0002)BQ! \u0001\u0005\u0012y\fab\u00195fG.\u0014%o\\1eG\u0006\u001cH\u000f\u0006\u0004p\u007f\u0006\u0005\u00111\u0001\u0005\u0006Sq\u0004\rA\u000b\u0005\u0006kq\u0004\rA\u000e\u0005\u0007\u0003\u000ba\b\u0019A\u0013\u0002#]LG\u000f\u001b\"s_\u0006$7-Y:u\u0011&tG\u000fC\u0004\u0002\n\u0001!\t\"a\u0003\u0002!\rDWmY6TQV4g\r\\3ICNDGcB8\u0002\u000e\u0005=\u0011\u0011\u0003\u0005\u0007S\u0005\u001d\u0001\u0019\u0001\u0016\t\rU\n9\u00011\u00017\u0011\u001d\t\u0019\"a\u0002A\u0002\u0015\n1c^5uQNCWO\u001a4mK\"\u000b7\u000f\u001b%j]RDq!a\u0006\u0001\t#\tI\"\u0001\ndQ\u0016\u001c7nU8si6+'oZ3K_&tG#B\u0013\u0002\u001c\u0005u\u0001BB\u0015\u0002\u0016\u0001\u0007!\u0006\u0003\u00046\u0003+\u0001\rA\u000e\u0005\b\u0003C\u0001A\u0011CA\u0012\u0003E\u0019\u0007.Z2l\u001d\u0016\u001cH\u000fT8pa*{\u0017N\u001c\u000b\b_\u0006\u0015\u0012qEA\u0015\u0011\u0019I\u0013q\u0004a\u0001U!1Q'a\bA\u0002YBq!a\u000b\u0002 \u0001\u0007Q%\u0001\txSRDg*Z:u\u0019>|\u0007\u000fS5oi\"9\u0011q\u0006\u0001\u0005\n\u0005E\u0012!F4fi\u001aK'o\u001d;Be\u001eLeNS8j]\"Kg\u000e\u001e\u000b\u0007\u0003g\t\u0019%!\u0012\u0011\t\u0005U\u0012Q\b\b\u0005\u0003o\tI\u0004\u0005\u0002S1%\u0019\u00111\b\r\u0002\rA\u0013X\rZ3g\u0013\u0011\ty$!\u0011\u0003\rM#(/\u001b8h\u0015\r\tY\u0004\u0007\u0005\u0007S\u00055\u0002\u0019\u0001\u0016\t\u0011\u0005\u001d\u0013Q\u0006a\u0001\u0003g\tAB[8j]\"Kg\u000e\u001e(b[\u0016<q!a\u0013\u0003\u0011\u0003\ti%A\rCCR\u001c\u0007\u000e\u00155zg&\u001c\u0017\r\u001c&pS:\u0014V\u000f\\3CCN,\u0007\u0003BA(\u0003#j\u0011A\u0001\u0004\u0007\u0003\tA\t!a\u0015\u0014\u0007\u0005Ec\u0003\u0003\u0005\u0002X\u0005EC\u0011AA-\u0003\u0019a\u0014N\\5u}Q\u0011\u0011Q\n\u0005\u000b\u0003;\n\tF1A\u0005\u0002\u0005}\u0013AI*F\u001b&{&jT%O?\n+\u0016\n\u0014#`\t&\u001bF+\u0013(D)~sEIV0S\u0003RKu*\u0006\u0002\u0002bA\u0019q#a\u0019\n\u0007\u0005\u0015\u0004D\u0001\u0004E_V\u0014G.\u001a\u0005\n\u0003S\n\t\u0006)A\u0005\u0003C\n1eU#N\u0013~Su*\u0013(`\u0005VKE\nR0E\u0013N#\u0016JT\"U?:#ek\u0018*B)&{\u0005\u0005")
public interface BatchPhysicalJoinRuleBase {
    public static double SEMI_JOIN_BUILD_DISTINCT_NDV_RATIO() {
        return BatchPhysicalJoinRuleBase$.MODULE$.SEMI_JOIN_BUILD_DISTINCT_NDV_RATIO();
    }

    public static /* synthetic */ boolean canUseJoinStrategy$(BatchPhysicalJoinRuleBase $this, Join join, TableConfig tableConfig, JoinStrategy joinStrategy) {
        return $this.canUseJoinStrategy(join, tableConfig, joinStrategy);
    }

    default public boolean canUseJoinStrategy(Join join, TableConfig tableConfig, JoinStrategy joinStrategy) {
        boolean bl;
        Option<JoinStrategy> firstValidJoinHint = this.getFirstValidJoinHint(join, tableConfig);
        if (firstValidJoinHint.nonEmpty()) {
            bl = ((Enum)firstValidJoinHint.get()).equals((Object)joinStrategy);
        } else {
            boolean isValid;
            boolean isValid2;
            Tuple2<Object, Object> tuple2 = this.checkJoinStrategyValid(join, tableConfig, joinStrategy, false);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            boolean bl2 = isValid2 = tuple2._1$mcZ$sp();
            bl = isValid = bl2;
        }
        return bl;
    }

    public static /* synthetic */ RelNode addLocalDistinctAgg$(BatchPhysicalJoinRuleBase $this, RelNode node, Seq distinctKeys) {
        return $this.addLocalDistinctAgg(node, (Seq<Object>)distinctKeys);
    }

    default public RelNode addLocalDistinctAgg(RelNode node, Seq<Object> distinctKeys) {
        RelTraitSet localRequiredTraitSet = node.getTraitSet().replace(FlinkConventions$.MODULE$.BATCH_PHYSICAL());
        RelNode newInput = RelOptRule.convert(node, localRequiredTraitSet);
        RelTraitSet providedTraitSet = localRequiredTraitSet;
        return new BatchPhysicalLocalHashAggregate(node.getCluster(), providedTraitSet, newInput, node.getRowType(), node.getRowType(), (int[])distinctKeys.toArray(ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), false, (Seq<Tuple2<AggregateCall, UserDefinedFunction>>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    public static /* synthetic */ boolean chooseSemiBuildDistinct$(BatchPhysicalJoinRuleBase $this, RelNode buildRel, Seq distinctKeys) {
        return $this.chooseSemiBuildDistinct(buildRel, (Seq<Object>)distinctKeys);
    }

    default public boolean chooseSemiBuildDistinct(RelNode buildRel, Seq<Object> distinctKeys) {
        RelMetadataQuery mq = buildRel.getCluster().getMetadataQuery();
        Double inputRows = mq.getRowCount(buildRel);
        Double ndvOfGroupKey = mq.getDistinctRowCount(buildRel, ImmutableBitSet.of((int[])distinctKeys.toArray(ClassTag$.MODULE$.Int())), null);
        return ndvOfGroupKey == null ? false : Predef$.MODULE$.Double2double(ndvOfGroupKey) / Predef$.MODULE$.Double2double(inputRows) < BatchPhysicalJoinRuleBase$.MODULE$.SEMI_JOIN_BUILD_DISTINCT_NDV_RATIO();
    }

    public static /* synthetic */ Option getFirstValidJoinHint$(BatchPhysicalJoinRuleBase $this, Join join, TableConfig tableConfig) {
        return $this.getFirstValidJoinHint(join, tableConfig);
    }

    default public Option<JoinStrategy> getFirstValidJoinHint(Join join, TableConfig tableConfig) {
        Option option;
        Object object = new Object();
        try {
            ImmutableList<RelHint> allHints = join.getHints();
            allHints.forEach(relHint -> {
                if (JoinStrategy.isJoinStrategy(relHint.hintName)) {
                    boolean isValid;
                    JoinStrategy joinStrategy = JoinStrategy.valueOf(relHint.hintName);
                    Tuple2<Object, Object> tuple2 = this.checkJoinStrategyValid(join, tableConfig, joinStrategy, true);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    boolean bl = isValid = tuple2._1$mcZ$sp();
                    boolean isValid2 = bl;
                    if (isValid2) {
                        throw new NonLocalReturnControl(object, (Object)new Some((Object)joinStrategy));
                    }
                }
            });
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public static /* synthetic */ Tuple2 checkJoinStrategyValid$(BatchPhysicalJoinRuleBase $this, Join join, TableConfig tableConfig, JoinStrategy triedJoinStrategy, boolean withHint) {
        return $this.checkJoinStrategyValid(join, tableConfig, triedJoinStrategy, withHint);
    }

    default public Tuple2<Object, Object> checkJoinStrategyValid(Join join, TableConfig tableConfig, JoinStrategy triedJoinStrategy, boolean withHint) {
        Tuple2<Object, Object> tuple2;
        if (withHint && !join.getJoinType().projectsRight()) {
            return new Tuple2.mcZZ.sp(false, false);
        }
        JoinStrategy joinStrategy = triedJoinStrategy;
        if (((Object)((Object)JoinStrategy.BROADCAST)).equals((Object)joinStrategy)) {
            tuple2 = this.checkBroadcast(join, tableConfig, withHint);
        } else if (((Object)((Object)JoinStrategy.SHUFFLE_HASH)).equals((Object)joinStrategy)) {
            tuple2 = this.checkShuffleHash(join, tableConfig, withHint);
        } else if (((Object)((Object)JoinStrategy.SHUFFLE_MERGE)).equals((Object)joinStrategy)) {
            tuple2 = new Tuple2<Object, Object>(this.checkSortMergeJoin(join, tableConfig), false);
        } else if (((Object)((Object)JoinStrategy.NEST_LOOP)).equals((Object)joinStrategy)) {
            tuple2 = this.checkNestLoopJoin(join, tableConfig, withHint);
        } else {
            throw new ValidationException(new StringBuilder(24).append("Unknown join strategy : ").append((Object)triedJoinStrategy).toString());
        }
        return tuple2;
    }

    private boolean isEquivJoin(Join join) {
        JoinInfo joinInfo = join.analyzeCondition();
        return !joinInfo.pairs().isEmpty();
    }

    public static /* synthetic */ Tuple2 checkBroadcast$(BatchPhysicalJoinRuleBase $this, Join join, TableConfig tableConfig, boolean withBroadcastHint) {
        return $this.checkBroadcast(join, tableConfig, withBroadcastHint);
    }

    default public Tuple2<Object, Object> checkBroadcast(Join join, TableConfig tableConfig, boolean withBroadcastHint) {
        Tuple2.mcZZ.sp sp2;
        if (!this.isEquivJoin(join) || TableConfigUtils.isOperatorDisabled(tableConfig, OperatorType.BroadcastHashJoin)) {
            return new Tuple2.mcZZ.sp(false, false);
        }
        if (withBroadcastHint) {
            Tuple2.mcZZ.sp sp3;
            boolean isLeftToBroadcastInHint = this.getFirstArgInJoinHint(join, JoinStrategy.BROADCAST.getJoinHintName()).equals("LEFT");
            JoinRelType joinRelType = join.getJoinType();
            if (((Object)((Object)JoinRelType.LEFT)).equals((Object)joinRelType)) {
                sp3 = new Tuple2.mcZZ.sp(!isLeftToBroadcastInHint, false);
            } else if (((Object)((Object)JoinRelType.RIGHT)).equals((Object)joinRelType)) {
                sp3 = new Tuple2.mcZZ.sp(isLeftToBroadcastInHint, true);
            } else if (((Object)((Object)JoinRelType.FULL)).equals((Object)joinRelType)) {
                sp3 = new Tuple2.mcZZ.sp(false, false);
            } else if (((Object)((Object)JoinRelType.INNER)).equals((Object)joinRelType)) {
                sp3 = new Tuple2.mcZZ.sp(true, isLeftToBroadcastInHint);
            } else {
                boolean bl = ((Object)((Object)JoinRelType.SEMI)).equals((Object)joinRelType) ? true : ((Object)((Object)JoinRelType.ANTI)).equals((Object)joinRelType);
                if (bl) {
                    sp3 = new Tuple2.mcZZ.sp(false, false);
                } else {
                    throw new MatchError((Object)joinRelType);
                }
            }
            sp2 = sp3;
        } else {
            Tuple2.mcZZ.sp sp4;
            Double leftSize = JoinUtil$.MODULE$.binaryRowRelNodeSize(join.getLeft());
            Double rightSize = JoinUtil$.MODULE$.binaryRowRelNodeSize(join.getRight());
            if (leftSize == null || rightSize == null) {
                return new Tuple2.mcZZ.sp(false, false);
            }
            Long threshold = (Long)tableConfig.get(OptimizerConfigOptions.TABLE_OPTIMIZER_BROADCAST_JOIN_THRESHOLD);
            boolean rightSizeSmallerThanThreshold = Predef$.MODULE$.Double2double(rightSize) <= (double)Predef$.MODULE$.Long2long(threshold);
            boolean leftSizeSmallerThanThreshold = Predef$.MODULE$.Double2double(leftSize) <= (double)Predef$.MODULE$.Long2long(threshold);
            boolean leftSmallerThanRight = Predef$.MODULE$.Double2double(leftSize) < Predef$.MODULE$.Double2double(rightSize);
            JoinRelType joinRelType = join.getJoinType();
            if (((Object)((Object)JoinRelType.LEFT)).equals((Object)joinRelType)) {
                sp4 = new Tuple2.mcZZ.sp(rightSizeSmallerThanThreshold, false);
            } else if (((Object)((Object)JoinRelType.RIGHT)).equals((Object)joinRelType)) {
                sp4 = new Tuple2.mcZZ.sp(leftSizeSmallerThanThreshold, true);
            } else if (((Object)((Object)JoinRelType.FULL)).equals((Object)joinRelType)) {
                sp4 = new Tuple2.mcZZ.sp(false, false);
            } else if (((Object)((Object)JoinRelType.INNER)).equals((Object)joinRelType)) {
                sp4 = new Tuple2.mcZZ.sp(leftSizeSmallerThanThreshold || rightSizeSmallerThanThreshold, leftSmallerThanRight);
            } else {
                boolean bl = ((Object)((Object)JoinRelType.SEMI)).equals((Object)joinRelType) ? true : ((Object)((Object)JoinRelType.ANTI)).equals((Object)joinRelType);
                if (bl) {
                    sp4 = new Tuple2.mcZZ.sp(rightSizeSmallerThanThreshold, false);
                } else {
                    throw new MatchError((Object)joinRelType);
                }
            }
            sp2 = sp4;
        }
        return sp2;
    }

    public static /* synthetic */ Tuple2 checkShuffleHash$(BatchPhysicalJoinRuleBase $this, Join join, TableConfig tableConfig, boolean withShuffleHashHint) {
        return $this.checkShuffleHash(join, tableConfig, withShuffleHashHint);
    }

    default public Tuple2<Object, Object> checkShuffleHash(Join join, TableConfig tableConfig, boolean withShuffleHashHint) {
        Tuple2.mcZZ.sp sp2;
        if (!this.isEquivJoin(join) || TableConfigUtils.isOperatorDisabled(tableConfig, OperatorType.ShuffleHashJoin)) {
            return new Tuple2.mcZZ.sp(false, false);
        }
        if (withShuffleHashHint) {
            boolean isLeftToBuild = this.getFirstArgInJoinHint(join, JoinStrategy.SHUFFLE_HASH.getJoinHintName()).equals("LEFT");
            sp2 = new Tuple2.mcZZ.sp(true, isLeftToBuild);
        } else {
            Double leftSize = JoinUtil$.MODULE$.binaryRowRelNodeSize(join.getLeft());
            Double rightSize = JoinUtil$.MODULE$.binaryRowRelNodeSize(join.getRight());
            boolean leftIsBuild = leftSize == null || rightSize == null || BoxesRunTime.equalsNumNum((Number)leftSize, (Number)rightSize) ? join.getJoinType().projectsRight() : Predef$.MODULE$.Double2double(leftSize) < Predef$.MODULE$.Double2double(rightSize);
            sp2 = new Tuple2.mcZZ.sp(true, leftIsBuild);
        }
        return sp2;
    }

    public static /* synthetic */ boolean checkSortMergeJoin$(BatchPhysicalJoinRuleBase $this, Join join, TableConfig tableConfig) {
        return $this.checkSortMergeJoin(join, tableConfig);
    }

    default public boolean checkSortMergeJoin(Join join, TableConfig tableConfig) {
        return this.isEquivJoin(join) && !TableConfigUtils.isOperatorDisabled(tableConfig, OperatorType.SortMergeJoin);
    }

    public static /* synthetic */ Tuple2 checkNestLoopJoin$(BatchPhysicalJoinRuleBase $this, Join join, TableConfig tableConfig, boolean withNestLoopHint) {
        return $this.checkNestLoopJoin(join, tableConfig, withNestLoopHint);
    }

    default public Tuple2<Object, Object> checkNestLoopJoin(Join join, TableConfig tableConfig, boolean withNestLoopHint) {
        boolean bl;
        if (TableConfigUtils.isOperatorDisabled(tableConfig, OperatorType.NestedLoopJoin)) {
            return new Tuple2.mcZZ.sp(false, false);
        }
        if (withNestLoopHint) {
            bl = this.getFirstArgInJoinHint(join, JoinStrategy.NEST_LOOP.getJoinHintName()).equals("LEFT");
        } else {
            boolean bl2;
            JoinRelType joinRelType = join.getJoinType();
            if (((Object)((Object)JoinRelType.LEFT)).equals((Object)joinRelType)) {
                bl2 = false;
            } else if (((Object)((Object)JoinRelType.RIGHT)).equals((Object)joinRelType)) {
                bl2 = true;
            } else {
                boolean bl3 = ((Object)((Object)JoinRelType.INNER)).equals((Object)joinRelType) ? true : ((Object)((Object)JoinRelType.FULL)).equals((Object)joinRelType);
                if (bl3) {
                    Double leftSize = JoinUtil$.MODULE$.binaryRowRelNodeSize(join.getLeft());
                    Double rightSize = JoinUtil$.MODULE$.binaryRowRelNodeSize(join.getRight());
                    bl2 = leftSize == null || rightSize == null ? true : Predef$.MODULE$.Double2double(leftSize) <= Predef$.MODULE$.Double2double(rightSize);
                } else {
                    boolean bl4 = ((Object)((Object)JoinRelType.SEMI)).equals((Object)joinRelType) ? true : ((Object)((Object)JoinRelType.ANTI)).equals((Object)joinRelType);
                    if (bl4) {
                        bl2 = false;
                    } else {
                        throw new MatchError((Object)joinRelType);
                    }
                }
            }
            bl = bl2;
        }
        boolean isLeftToBuild = bl;
        return new Tuple2.mcZZ.sp(true, isLeftToBuild);
    }

    private String getFirstArgInJoinHint(Join join, String joinHintName) {
        Object object = new Object();
        try {
            join.getHints().forEach(hint -> {
                if (hint.hintName.equals(joinHintName)) {
                    throw new NonLocalReturnControl(object, (Object)hint.listOptions.get(0));
                }
            });
            throw new TableException(String.format("Fail to find the join hint `%s` among `%s`", joinHintName, ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(join.getHints()).map((Function1 & Serializable & scala.Serializable)hint -> hint.hintName, Buffer$.MODULE$.canBuildFrom())).mkString(",")));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (String)ex.value();
        }
    }

    public static void $init$(BatchPhysicalJoinRuleBase $this) {
    }
}

