/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.source.reader.fetcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.SourceReaderOptions;
import org.apache.flink.connector.base.source.reader.fetcher.SplitFetcher;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.connector.base.source.reader.synchronization.FutureCompletingBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public abstract class SplitFetcherManager<E, SplitT extends SourceSplit> {
    private static final Logger LOG = LoggerFactory.getLogger(SplitFetcherManager.class);
    private final Consumer<Throwable> errorHandler;
    private final AtomicInteger fetcherIdGenerator;
    private final Supplier<SplitReader<E, SplitT>> splitReaderFactory;
    private final AtomicReference<Throwable> uncaughtFetcherException;
    private final FutureCompletingBlockingQueue<RecordsWithSplitIds<E>> elementsQueue;
    protected final Map<Integer, SplitFetcher<E, SplitT>> fetchers;
    private final AtomicInteger fetchersToShutDown;
    private final ExecutorService executors;
    private volatile boolean closed;
    private final Consumer<Collection<String>> splitFinishedHook;
    private final boolean allowUnalignedSourceSplits;

    public SplitFetcherManager(Supplier<SplitReader<E, SplitT>> splitReaderFactory, Configuration configuration) {
        this(splitReaderFactory, configuration, ignore -> {});
    }

    public SplitFetcherManager(Supplier<SplitReader<E, SplitT>> splitReaderFactory, Configuration configuration, Consumer<Collection<String>> splitFinishedHook) {
        this.elementsQueue = new FutureCompletingBlockingQueue((Integer)configuration.get(SourceReaderOptions.ELEMENT_QUEUE_CAPACITY));
        this.errorHandler = new Consumer<Throwable>(){

            @Override
            public void accept(Throwable t) {
                LOG.error("Received uncaught exception.", t);
                if (!SplitFetcherManager.this.uncaughtFetcherException.compareAndSet(null, t)) {
                    SplitFetcherManager.this.uncaughtFetcherException.get().addSuppressed(t);
                }
                SplitFetcherManager.this.elementsQueue.notifyAvailable();
            }
        };
        this.splitReaderFactory = splitReaderFactory;
        this.splitFinishedHook = splitFinishedHook;
        this.uncaughtFetcherException = new AtomicReference<Object>(null);
        this.fetcherIdGenerator = new AtomicInteger(0);
        this.fetchers = new ConcurrentHashMap<Integer, SplitFetcher<E, SplitT>>();
        this.allowUnalignedSourceSplits = (Boolean)configuration.get(PipelineOptions.ALLOW_UNALIGNED_SOURCE_SPLITS);
        this.fetchersToShutDown = new AtomicInteger(0);
        String taskThreadName = Thread.currentThread().getName();
        this.executors = Executors.newCachedThreadPool(r -> new Thread(r, "Source Data Fetcher for " + taskThreadName));
        this.closed = false;
    }

    public abstract void addSplits(List<SplitT> var1);

    public abstract void removeSplits(List<SplitT> var1);

    public void pauseOrResumeSplits(Collection<String> splitIdsToPause, Collection<String> splitIdsToResume) {
        for (SplitFetcher<E, SplitT> fetcher : this.fetchers.values()) {
            Map<String, SplitT> idToSplit = fetcher.assignedSplits();
            List<SplitT> splitsToPause = this.lookupInAssignment(splitIdsToPause, idToSplit);
            List<SplitT> splitsToResume = this.lookupInAssignment(splitIdsToResume, idToSplit);
            if (splitsToPause.isEmpty() && splitsToResume.isEmpty()) continue;
            fetcher.pauseOrResumeSplits(splitsToPause, splitsToResume);
        }
    }

    private List<SplitT> lookupInAssignment(Collection<String> splitIds, Map<String, SplitT> assignment) {
        ArrayList<SourceSplit> splits = new ArrayList<SourceSplit>();
        for (String s : splitIds) {
            SourceSplit split = (SourceSplit)assignment.get(s);
            if (split == null) continue;
            splits.add(split);
        }
        return splits;
    }

    protected void startFetcher(SplitFetcher<E, SplitT> fetcher) {
        this.executors.submit(fetcher);
    }

    protected synchronized SplitFetcher<E, SplitT> createSplitFetcher() {
        if (this.closed) {
            throw new IllegalStateException("The split fetcher manager has closed.");
        }
        SplitReader<E, SplitT> splitReader = this.splitReaderFactory.get();
        int fetcherId = this.fetcherIdGenerator.getAndIncrement();
        this.fetchersToShutDown.incrementAndGet();
        SplitFetcher<E, SplitT> splitFetcher = new SplitFetcher<E, SplitT>(fetcherId, this.elementsQueue, splitReader, this.errorHandler, () -> {
            this.fetchers.remove(fetcherId);
            this.fetchersToShutDown.decrementAndGet();
            this.elementsQueue.notifyAvailable();
        }, this.splitFinishedHook, this.allowUnalignedSourceSplits);
        this.fetchers.put(fetcherId, splitFetcher);
        return splitFetcher;
    }

    public boolean maybeShutdownFinishedFetchers() {
        Iterator<Map.Entry<Integer, SplitFetcher<E, SplitT>>> iter = this.fetchers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, SplitFetcher<E, SplitT>> entry = iter.next();
            SplitFetcher<E, SplitT> fetcher = entry.getValue();
            if (!fetcher.isIdle()) continue;
            LOG.info("Closing splitFetcher {} because it is idle.", (Object)entry.getKey());
            fetcher.shutdown(true);
            iter.remove();
        }
        return this.fetchers.isEmpty();
    }

    @Internal
    public FutureCompletingBlockingQueue<RecordsWithSplitIds<E>> getQueue() {
        return this.elementsQueue;
    }

    public synchronized void close(long timeoutMs) throws Exception {
        long startTime = System.currentTimeMillis();
        this.closed = true;
        this.fetchers.values().forEach(SplitFetcher::shutdown);
        this.executors.submit(() -> {
            while (this.fetchersToShutDown.get() > 0 && System.currentTimeMillis() - startTime < timeoutMs) {
                this.elementsQueue.getAvailabilityFuture().thenRun(() -> this.elementsQueue.poll().recycle());
            }
        });
        this.executors.shutdown();
        if (!this.executors.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS)) {
            LOG.warn("Failed to close the split fetchers in {} ms. There are still {} split fetchers running", (Object)timeoutMs, (Object)this.fetchersToShutDown);
        }
    }

    public void checkErrors() {
        if (this.uncaughtFetcherException.get() != null) {
            throw new RuntimeException("One or more fetchers have encountered exception", this.uncaughtFetcherException.get());
        }
    }

    @VisibleForTesting
    public int getNumAliveFetchers() {
        return this.fetchers.size();
    }
}

