/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.asyncprocessing.state;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.v2.MapState;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.common.state.v2.ValueState;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.core.state.StateFutureUtils;
import org.apache.flink.runtime.state.v2.MapStateDescriptor;
import org.apache.flink.runtime.state.v2.ValueStateDescriptor;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.join.stream.asyncprocessing.state.OuterJoinRecordAsyncStateView;
import org.apache.flink.table.runtime.operators.join.stream.utils.JoinInputSideSpec;
import org.apache.flink.table.runtime.operators.join.stream.utils.OuterRecord;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.util.StateConfigUtil;
import org.apache.flink.util.Preconditions;

public final class OuterJoinRecordAsyncStateViews {
    public static OuterJoinRecordAsyncStateView create(StreamingRuntimeContext ctx, String stateName, JoinInputSideSpec inputSideSpec, InternalTypeInfo<RowData> recordType, long retentionTime) {
        StateTtlConfig ttlConfig = StateConfigUtil.createTtlConfig(retentionTime);
        if (inputSideSpec.hasUniqueKey()) {
            if (inputSideSpec.joinKeyContainsUniqueKey()) {
                return new JoinKeyContainsUniqueKey(ctx, stateName, recordType, ttlConfig);
            }
            return new InputSideHasUniqueKey(ctx, stateName, recordType, inputSideSpec.getUniqueKeyType(), inputSideSpec.getUniqueKeySelector(), ttlConfig);
        }
        return new InputSideHasNoUniqueKey(ctx, stateName, recordType, ttlConfig);
    }

    private static final class InputSideHasNoUniqueKey
    implements OuterJoinRecordAsyncStateView {
        private final MapState<RowData, Tuple2<Integer, Integer>> recordState;

        private InputSideHasNoUniqueKey(StreamingRuntimeContext ctx, String stateName, InternalTypeInfo<RowData> recordType, StateTtlConfig ttlConfig) {
            TupleTypeInfo tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{Types.INT, Types.INT});
            MapStateDescriptor recordStateDesc = new MapStateDescriptor(stateName, recordType, (TypeInformation)tupleTypeInfo);
            if (ttlConfig.isEnabled()) {
                recordStateDesc.enableTimeToLive(ttlConfig);
            }
            this.recordState = ctx.getMapState(recordStateDesc);
        }

        @Override
        public StateFuture<Void> addRecord(RowData record, int numOfAssociations) {
            return this.recordState.asyncGet((Object)record).thenApply(tuple -> {
                if (tuple != null) {
                    tuple.f0 = (Integer)tuple.f0 + 1;
                    tuple.f1 = numOfAssociations;
                    return tuple;
                }
                return Tuple2.of((Object)1, (Object)numOfAssociations);
            }).thenCompose(updatedTuple -> this.recordState.asyncPut((Object)record, updatedTuple));
        }

        @Override
        public StateFuture<Void> updateNumOfAssociations(RowData record, int numOfAssociations) {
            return this.recordState.asyncGet((Object)record).thenApply(tuple -> {
                if (tuple != null) {
                    tuple.f1 = numOfAssociations;
                    return tuple;
                }
                return Tuple2.of((Object)1, (Object)numOfAssociations);
            }).thenCompose(updatedTuple -> this.recordState.asyncPut((Object)record, updatedTuple));
        }

        @Override
        public StateFuture<Void> retractRecord(RowData record) {
            return this.recordState.asyncGet((Object)record).thenCompose(tuple -> {
                if (tuple != null) {
                    if ((Integer)tuple.f0 > 1) {
                        tuple.f0 = (Integer)tuple.f0 - 1;
                        return this.recordState.asyncPut((Object)record, tuple);
                    }
                    return this.recordState.asyncRemove((Object)record);
                }
                return StateFutureUtils.completedVoidFuture();
            });
        }

        @Override
        public StateFuture<List<OuterRecord>> findMatchedRecordsAndNumOfAssociations(Function<RowData, Boolean> condition) {
            ArrayList matchedRecords = new ArrayList();
            return this.recordState.asyncEntries().thenCompose(it -> it.onNext(entry -> {
                RowData record = (RowData)entry.getKey();
                int appearTimes = (Integer)((Tuple2)entry.getValue()).f0;
                int associatedNum = (Integer)((Tuple2)entry.getValue()).f1;
                if (((Boolean)condition.apply(record)).booleanValue()) {
                    for (int i = 0; i < appearTimes; ++i) {
                        matchedRecords.add(new OuterRecord(record, associatedNum));
                    }
                }
            })).thenApply(VOID -> matchedRecords);
        }
    }

    private static final class InputSideHasUniqueKey
    implements OuterJoinRecordAsyncStateView {
        private final MapState<RowData, Tuple2<RowData, Integer>> recordState;
        private final KeySelector<RowData, RowData> uniqueKeySelector;

        private InputSideHasUniqueKey(StreamingRuntimeContext ctx, String stateName, InternalTypeInfo<RowData> recordType, InternalTypeInfo<RowData> uniqueKeyType, KeySelector<RowData, RowData> uniqueKeySelector, StateTtlConfig ttlConfig) {
            Preconditions.checkNotNull(uniqueKeyType);
            Preconditions.checkNotNull(uniqueKeySelector);
            TupleTypeInfo valueTypeInfo = new TupleTypeInfo(new TypeInformation[]{recordType, Types.INT});
            MapStateDescriptor recordStateDesc = new MapStateDescriptor(stateName, uniqueKeyType, (TypeInformation)valueTypeInfo);
            if (ttlConfig.isEnabled()) {
                recordStateDesc.enableTimeToLive(ttlConfig);
            }
            this.recordState = ctx.getMapState(recordStateDesc);
            this.uniqueKeySelector = uniqueKeySelector;
        }

        @Override
        public StateFuture<Void> addRecord(RowData record, int numOfAssociations) {
            return StateFutureUtils.completedVoidFuture().thenCompose(VOID -> {
                RowData uniqueKey = (RowData)this.uniqueKeySelector.getKey((Object)record);
                return this.recordState.asyncPut((Object)uniqueKey, (Object)Tuple2.of((Object)record, (Object)numOfAssociations));
            });
        }

        @Override
        public StateFuture<Void> updateNumOfAssociations(RowData record, int numOfAssociations) {
            return StateFutureUtils.completedVoidFuture().thenCompose(VOID -> {
                RowData uniqueKey = (RowData)this.uniqueKeySelector.getKey((Object)record);
                return this.recordState.asyncPut((Object)uniqueKey, (Object)Tuple2.of((Object)record, (Object)numOfAssociations));
            });
        }

        @Override
        public StateFuture<Void> retractRecord(RowData record) {
            return StateFutureUtils.completedVoidFuture().thenCompose(VOID -> {
                RowData uniqueKey = (RowData)this.uniqueKeySelector.getKey((Object)record);
                return this.recordState.asyncRemove((Object)uniqueKey);
            });
        }

        @Override
        public StateFuture<List<OuterRecord>> findMatchedRecordsAndNumOfAssociations(Function<RowData, Boolean> condition) {
            ArrayList matchedRecords = new ArrayList();
            return this.recordState.asyncValues().thenCompose(it -> it.onNext(v -> {
                if (((Boolean)condition.apply((RowData)v.f0)).booleanValue()) {
                    matchedRecords.add(new OuterRecord((RowData)v.f0, (Integer)v.f1));
                }
            })).thenApply(VOID -> matchedRecords);
        }
    }

    private static final class JoinKeyContainsUniqueKey
    implements OuterJoinRecordAsyncStateView {
        private final ValueState<Tuple2<RowData, Integer>> recordState;
        private final List<OuterRecord> reusedList;

        private JoinKeyContainsUniqueKey(StreamingRuntimeContext ctx, String stateName, InternalTypeInfo<RowData> recordType, StateTtlConfig ttlConfig) {
            TupleTypeInfo valueTypeInfo = new TupleTypeInfo(new TypeInformation[]{recordType, Types.INT});
            ValueStateDescriptor recordStateDesc = new ValueStateDescriptor(stateName, (TypeInformation)valueTypeInfo);
            if (ttlConfig.isEnabled()) {
                recordStateDesc.enableTimeToLive(ttlConfig);
            }
            this.recordState = ctx.getValueState(recordStateDesc);
            this.reusedList = new ArrayList<OuterRecord>(1);
        }

        @Override
        public StateFuture<Void> addRecord(RowData record, int numOfAssociations) {
            return this.recordState.asyncUpdate((Object)Tuple2.of((Object)record, (Object)numOfAssociations));
        }

        @Override
        public StateFuture<Void> updateNumOfAssociations(RowData record, int numOfAssociations) {
            return this.recordState.asyncUpdate((Object)Tuple2.of((Object)record, (Object)numOfAssociations));
        }

        @Override
        public StateFuture<Void> retractRecord(RowData record) {
            return this.recordState.asyncClear();
        }

        @Override
        public StateFuture<List<OuterRecord>> findMatchedRecordsAndNumOfAssociations(Function<RowData, Boolean> condition) {
            return this.recordState.asyncValue().thenCompose(tuple -> {
                this.reusedList.clear();
                if (tuple != null && ((Boolean)condition.apply((RowData)tuple.f0)).booleanValue()) {
                    this.reusedList.add(new OuterRecord((RowData)tuple.f0, (Integer)tuple.f1));
                }
                return StateFutureUtils.completedFuture(this.reusedList);
            });
        }
    }
}

