/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank;

import org.apache.flink.shaded.guava32.com.google.common.cache.RemovalCause;
import org.apache.flink.shaded.guava32.com.google.common.cache.RemovalListener;
import org.apache.flink.shaded.guava32.com.google.common.cache.RemovalNotification;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.function.ThrowingConsumer;

public class TopNBufferCacheRemovalListener<V>
implements RemovalListener<RowData, V> {
    private final KeyContext keyContext;
    private final ThrowingConsumer<V, Exception> callBack;

    public TopNBufferCacheRemovalListener(KeyContext keyContext, ThrowingConsumer<V, Exception> callBack) {
        this.keyContext = keyContext;
        this.callBack = callBack;
    }

    public void onRemoval(RemovalNotification<RowData, V> removalNotification) {
        if (removalNotification.getCause() != RemovalCause.SIZE || removalNotification.getValue() == null) {
            return;
        }
        RowData previousKey = (RowData)this.keyContext.getCurrentKey();
        RowData partitionKey = (RowData)removalNotification.getKey();
        Object value = removalNotification.getValue();
        if (partitionKey == null || value == null) {
            return;
        }
        this.keyContext.setCurrentKey((Object)partitionKey);
        try {
            this.callBack.accept(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute callback", e);
        }
        finally {
            this.keyContext.setCurrentKey((Object)previousKey);
        }
    }
}

