/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.support.table;

public class TableHeader {
    private int maxWidth = -1;
    private int width = 0;
    private String name;

    public TableHeader(String name, int width) {
        this.width = width;
        this.name = name;
    }

    public TableHeader(String name) {
        this.name = name;
        this.width = name == null ? 0 : name.length();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void updateWidth(int width) {
        if (this.width < width) {
            this.width = this.maxWidth > 0 && this.maxWidth < width ? this.maxWidth : width;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.maxWidth;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.width;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableHeader other = (TableHeader)obj;
        if (this.maxWidth != other.maxWidth) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.width == other.width;
    }
}

