/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.admin.internal.AdminDistributedSystemImpl;
import org.apache.geode.admin.jmx.internal.StatAlertsAggregator;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.internal.admin.StatAlert;
import org.apache.geode.internal.admin.remote.RemoteGemFireVM;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class AlertsNotificationMessage
extends PooledDistributionMessage {
    private StatAlert[] _alerts;

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeObjectArray(this._alerts, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this._alerts = (StatAlert[])DataSerializer.readObjectArray(in);
    }

    public int getDSFID() {
        return 1072;
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        AdminDistributedSystemImpl ds = AdminDistributedSystemImpl.getConnectedInstance();
        if (ds instanceof StatAlertsAggregator) {
            StatAlertsAggregator aggregator = (StatAlertsAggregator)((Object)ds);
            RemoteGemFireVM remoteVM = dm.getAgent().getMemberById(this.getSender());
            aggregator.processNotifications(this._alerts, remoteVM);
        }
    }

    public StatAlert[] getAlerts() {
        return this._alerts;
    }

    public void setAlerts(StatAlert[] alerts) {
        this._alerts = alerts;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AlertsNotification[");
        sb.append("count = " + this._alerts.length);
        sb.append(" (");
        for (int i = 0; i < this._alerts.length; ++i) {
            sb.append(this._alerts[i].toString());
            if (i == this._alerts.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")]");
        return sb.toString();
    }
}

