/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.backup.BackupReplyProcessor;
import org.apache.geode.internal.cache.backup.BackupResponse;
import org.apache.geode.internal.cache.backup.BackupResultCollector;
import org.apache.geode.internal.cache.backup.BackupWriter;
import org.apache.geode.internal.cache.backup.BackupWriterFactory;
import org.apache.geode.internal.cache.backup.PrepareBackup;
import org.apache.geode.internal.cache.backup.PrepareBackupRequest;
import org.apache.geode.internal.cache.backup.PrepareBackupStep;

class PrepareBackupFactory {
    PrepareBackupFactory() {
    }

    BackupReplyProcessor createReplyProcessor(BackupResultCollector resultCollector, DistributionManager dm, Set<InternalDistributedMember> recipients) {
        return new BackupReplyProcessor(resultCollector, dm, recipients);
    }

    PrepareBackupRequest createRequest(InternalDistributedMember sender, Set<InternalDistributedMember> recipients, int processorId, Properties properties) {
        return new PrepareBackupRequest(sender, recipients, processorId, this, properties);
    }

    PrepareBackup createPrepareBackup(InternalDistributedMember member, InternalCache cache, Properties properties) {
        String memberId = this.cleanSpecialCharacters(member.toString());
        BackupWriter backupWriter = BackupWriterFactory.getFactoryForType(properties.getProperty("TYPE")).createWriter(properties, memberId);
        return new PrepareBackup(member, cache, backupWriter);
    }

    BackupResponse createBackupResponse(InternalDistributedMember sender, HashSet<PersistentID> persistentIds) {
        return new BackupResponse(sender, persistentIds);
    }

    PrepareBackupStep createPrepareBackupStep(DistributionManager dm, InternalDistributedMember member, InternalCache cache, Set<InternalDistributedMember> recipients, PrepareBackupFactory prepareBackupFactory, Properties properties) {
        return new PrepareBackupStep(dm, member, cache, recipients, prepareBackupFactory, properties);
    }

    private String cleanSpecialCharacters(String string) {
        return string.replaceAll("[^\\w]+", "_");
    }
}

