/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import javax.management.Notification;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.RegionEvent;
import org.apache.geode.management.internal.MBeanProxyFactory;
import org.apache.geode.management.internal.NotificationHubClient;
import org.apache.geode.management.internal.NotificationKey;

public class NotificationCacheListener
implements CacheListener<NotificationKey, Notification> {
    private final NotificationHubClient notifClient;
    private volatile boolean readyForEvents;

    public NotificationCacheListener(MBeanProxyFactory proxyHelper) {
        this.notifClient = new NotificationHubClient(proxyHelper);
        this.readyForEvents = false;
    }

    @Override
    public void afterCreate(EntryEvent<NotificationKey, Notification> event) {
        if (!this.readyForEvents) {
            return;
        }
        this.notifClient.sendNotification(event);
    }

    @Override
    public void afterDestroy(EntryEvent<NotificationKey, Notification> event) {
    }

    @Override
    public void afterInvalidate(EntryEvent<NotificationKey, Notification> event) {
    }

    @Override
    public void afterRegionClear(RegionEvent<NotificationKey, Notification> event) {
    }

    @Override
    public void afterRegionCreate(RegionEvent<NotificationKey, Notification> event) {
    }

    @Override
    public void afterRegionDestroy(RegionEvent<NotificationKey, Notification> event) {
    }

    @Override
    public void afterRegionInvalidate(RegionEvent<NotificationKey, Notification> event) {
    }

    @Override
    public void afterRegionLive(RegionEvent<NotificationKey, Notification> event) {
    }

    @Override
    public void afterUpdate(EntryEvent<NotificationKey, Notification> event) {
        if (!this.readyForEvents) {
            return;
        }
        this.notifClient.sendNotification(event);
    }

    @Override
    public void close() {
    }

    public void markReady() {
        this.readyForEvents = true;
    }
}

