/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.KeyValueSerializer;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.types.RowType;

public class KeyValueDataFileRecordReader
implements RecordReader<KeyValue> {
    private final RecordReader<InternalRow> reader;
    private final KeyValueSerializer serializer;
    private final int level;
    private final boolean ignoreDelete;

    public KeyValueDataFileRecordReader(RecordReader<InternalRow> reader, RowType keyType, RowType valueType, int level, boolean ignoreDelete) {
        this.reader = reader;
        this.serializer = new KeyValueSerializer(keyType, valueType);
        this.level = level;
        this.ignoreDelete = ignoreDelete;
    }

    @Nullable
    public RecordReader.RecordIterator<KeyValue> readBatch() throws IOException {
        RecordReader.RecordIterator iterator = this.reader.readBatch();
        if (iterator == null) {
            return null;
        }
        RecordReader.RecordIterator transformed = iterator.transform(internalRow -> internalRow == null ? null : this.serializer.fromRow((InternalRow)internalRow).setLevel(this.level));
        return this.ignoreDelete ? transformed.filter(KeyValue::isAdd) : transformed;
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

