/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.dev.failsafe.internal;

import io.trino.jdbc.$internal.dev.failsafe.CircuitBreaker;
import io.trino.jdbc.$internal.dev.failsafe.CircuitBreakerConfig;
import io.trino.jdbc.$internal.dev.failsafe.ExecutionContext;
import io.trino.jdbc.$internal.dev.failsafe.internal.CircuitBreakerImpl;
import io.trino.jdbc.$internal.dev.failsafe.internal.CircuitState;
import io.trino.jdbc.$internal.dev.failsafe.internal.CircuitStats;

class ClosedState<R>
extends CircuitState<R> {
    public ClosedState(CircuitBreakerImpl<R> breaker) {
        super(breaker, CircuitStats.create(breaker, ClosedState.capacityFor(breaker), true, null));
    }

    @Override
    public boolean tryAcquirePermit() {
        return true;
    }

    @Override
    public CircuitBreaker.State getState() {
        return CircuitBreaker.State.CLOSED;
    }

    @Override
    public synchronized void handleConfigChange() {
        this.stats = CircuitStats.create(this.breaker, ClosedState.capacityFor(this.breaker), true, this.stats);
    }

    @Override
    synchronized void checkThreshold(ExecutionContext<R> context) {
        double failureRateThreshold;
        if (this.stats.getExecutionCount() >= this.config.getFailureExecutionThreshold() && ((failureRateThreshold = (double)this.config.getFailureRateThreshold()) != 0.0 && (double)this.stats.getFailureRate() >= failureRateThreshold || failureRateThreshold == 0.0 && this.stats.getFailureCount() >= this.config.getFailureThreshold())) {
            this.breaker.open(context);
        }
    }

    private static int capacityFor(CircuitBreaker<?> breaker) {
        if (((CircuitBreakerConfig)breaker.getConfig()).getFailureExecutionThreshold() != 0) {
            return ((CircuitBreakerConfig)breaker.getConfig()).getFailureExecutionThreshold();
        }
        return ((CircuitBreakerConfig)breaker.getConfig()).getFailureThresholdingCapacity();
    }
}

