/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hive.converter;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.gravitino.catalog.hive.StorageFormat;
import org.apache.gravitino.hive.HiveColumn;
import org.apache.gravitino.hive.HivePartition;
import org.apache.gravitino.hive.HiveTable;
import org.apache.gravitino.hive.converter.HiveDataTypeConverter;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.NamedReference;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Distributions;
import org.apache.gravitino.rel.expressions.sorts.SortDirection;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.sorts.SortOrders;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.gravitino.rel.types.Type;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;

public class HiveTableConverter {
    public static HiveTable fromHiveTable(Table table) {
        Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"Table cannot be null");
        AuditInfo auditInfo = HiveTableConverter.getAuditInfo(table);
        Distribution distribution = HiveTableConverter.getDistribution(table);
        SortOrder[] sortOrders = HiveTableConverter.getSortOrders(table);
        Column[] columns = HiveTableConverter.getColumns(table);
        Transform[] partitioning = HiveTableConverter.getPartitioning(table);
        String catalogName = null;
        try {
            Method getCatNameMethod = table.getClass().getMethod("getCatName", new Class[0]);
            catalogName = (String)getCatNameMethod.invoke((Object)table, new Object[0]);
        }
        catch (Exception getCatNameMethod) {
            // empty catch block
        }
        HiveTable hiveTable = (HiveTable)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)HiveTable.builder().withName(table.getTableName())).withComment((String)table.getParameters().get("comment"))).withProperties(HiveTableConverter.buildTableProperties(table))).withColumns(columns)).withDistribution(distribution)).withSortOrders(sortOrders)).withAuditInfo(auditInfo)).withPartitioning(partitioning)).withCatalogName(catalogName).withDatabaseName(table.getDbName()).build();
        return hiveTable;
    }

    private static Map<String, String> buildTableProperties(Table table) {
        HashMap properties = Maps.newHashMap((Map)table.getParameters());
        Optional.ofNullable(table.getTableType()).ifPresent(t -> properties.put("table-type", t));
        StorageDescriptor sd = table.getSd();
        properties.put("location", sd.getLocation());
        properties.put("input-format", sd.getInputFormat());
        properties.put("output-format", sd.getOutputFormat());
        SerDeInfo serdeInfo = sd.getSerdeInfo();
        Optional.ofNullable(serdeInfo.getName()).ifPresent(name -> properties.put("serde-name", name));
        Optional.ofNullable(serdeInfo.getSerializationLib()).ifPresent(lib -> properties.put("serde-lib", lib));
        Optional.ofNullable(serdeInfo.getParameters()).ifPresent(p -> p.forEach((k, v) -> properties.put("serde.parameter." + k, v)));
        return properties;
    }

    public static Table toHiveTable(HiveTable hiveTable) {
        Preconditions.checkArgument((hiveTable != null ? 1 : 0) != 0, (Object)"HiveTable cannot be null");
        String dbName = hiveTable.databaseName();
        Preconditions.checkArgument((dbName != null ? 1 : 0) != 0, (Object)"Database name cannot be null");
        Table table = new Table();
        table.setTableName(hiveTable.name());
        table.setDbName(dbName);
        String tableType = hiveTable.properties().getOrDefault("table-type", String.valueOf(TableType.MANAGED_TABLE));
        table.setTableType(tableType.toUpperCase());
        List<FieldSchema> partitionFields = hiveTable.partitionFieldNames().stream().map(fieldName -> HiveTableConverter.buildPartitionKeyField(fieldName, hiveTable)).collect(Collectors.toList());
        table.setSd(HiveTableConverter.buildStorageDescriptor(hiveTable, partitionFields));
        table.setParameters(HiveTableConverter.buildTableParameters(hiveTable));
        table.setPartitionKeys(partitionFields);
        table.setOwner(hiveTable.auditInfo().creator());
        table.setCreateTime(Math.toIntExact(hiveTable.auditInfo().createTime().getEpochSecond()));
        return table;
    }

    private static FieldSchema buildPartitionKeyField(String fieldName, HiveTable table) {
        Column partitionColumn = Arrays.stream(table.columns()).filter(c -> c.name().equals(fieldName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Partition column %s does not exist", fieldName)));
        return new FieldSchema(partitionColumn.name(), HiveDataTypeConverter.CONVERTER.fromGravitino(partitionColumn.dataType()).getQualifiedName(), partitionColumn.comment());
    }

    private static StorageDescriptor buildStorageDescriptor(HiveTable table, List<FieldSchema> partitionFields) {
        StorageDescriptor strgDesc = new StorageDescriptor();
        List partitionKeys = partitionFields.stream().map(FieldSchema::getName).collect(Collectors.toList());
        strgDesc.setCols(Arrays.stream(table.columns()).filter(c -> !partitionKeys.contains(c.name())).map(c -> new FieldSchema(c.name(), HiveDataTypeConverter.CONVERTER.fromGravitino(c.dataType()).getQualifiedName(), c.comment())).collect(Collectors.toList()));
        Optional.ofNullable((String)table.properties().get("location")).ifPresent(arg_0 -> ((StorageDescriptor)strgDesc).setLocation(arg_0));
        strgDesc.setSerdeInfo(HiveTableConverter.buildSerDeInfo(table));
        StorageFormat storageFormat = StorageFormat.valueOf((String)table.properties().getOrDefault("format", String.valueOf(StorageFormat.TEXTFILE)).toUpperCase());
        strgDesc.setInputFormat(storageFormat.getInputFormat());
        strgDesc.setOutputFormat(storageFormat.getOutputFormat());
        Optional.ofNullable((String)table.properties().get("input-format")).ifPresent(arg_0 -> ((StorageDescriptor)strgDesc).setInputFormat(arg_0));
        Optional.ofNullable((String)table.properties().get("output-format")).ifPresent(arg_0 -> ((StorageDescriptor)strgDesc).setOutputFormat(arg_0));
        if (table.sortOrder() != null && table.sortOrder().length > 0) {
            for (SortOrder sortOrder : table.sortOrder()) {
                String columnName = ((NamedReference.FieldReference)sortOrder.expression()).fieldName()[0];
                strgDesc.addToSortCols(new Order(columnName, sortOrder.direction() == SortDirection.ASCENDING ? 1 : 0));
            }
        }
        if (table.distribution() != null && !Distributions.NONE.equals(table.distribution())) {
            strgDesc.setBucketCols(Arrays.stream(table.distribution().expressions()).map(t -> ((NamedReference.FieldReference)t).fieldName()[0]).collect(Collectors.toList()));
            strgDesc.setNumBuckets(table.distribution().number());
        }
        return strgDesc;
    }

    private static SerDeInfo buildSerDeInfo(HiveTable table) {
        SerDeInfo serDeInfo = new SerDeInfo();
        serDeInfo.setName(table.properties().getOrDefault("serde-name", table.name()));
        StorageFormat storageFormat = StorageFormat.valueOf((String)table.properties().getOrDefault("format", String.valueOf(StorageFormat.TEXTFILE)).toUpperCase());
        serDeInfo.setSerializationLib(storageFormat.getSerde());
        Optional.ofNullable((String)table.properties().get("serde-lib")).ifPresent(arg_0 -> ((SerDeInfo)serDeInfo).setSerializationLib(arg_0));
        table.properties().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("serde.parameter.")).forEach(e -> serDeInfo.putToParameters(((String)e.getKey()).substring("serde.parameter.".length()), (String)e.getValue()));
        return serDeInfo;
    }

    private static Map<String, String> buildTableParameters(HiveTable table) {
        HashMap parameters = Maps.newHashMap((Map)table.properties());
        Optional.ofNullable(table.comment()).ifPresent(c -> parameters.put("comment", c));
        if (TableType.EXTERNAL_TABLE.name().equalsIgnoreCase((String)table.properties().get("table-type"))) {
            parameters.put("EXTERNAL", "TRUE");
        } else {
            parameters.put("EXTERNAL", "FALSE");
        }
        parameters.remove("location");
        parameters.remove("table-type");
        parameters.remove("input-format");
        parameters.remove("output-format");
        parameters.remove("serde-name");
        parameters.remove("serde-lib");
        parameters.remove("format");
        parameters.keySet().removeIf(k -> k.startsWith("serde.parameter."));
        return parameters;
    }

    public static AuditInfo getAuditInfo(Table table) {
        AuditInfo.Builder auditInfoBuilder = AuditInfo.builder();
        Optional.ofNullable(table.getOwner()).ifPresent(arg_0 -> ((AuditInfo.Builder)auditInfoBuilder).withCreator(arg_0));
        if (table.isSetCreateTime()) {
            auditInfoBuilder.withCreateTime(Instant.ofEpochSecond(table.getCreateTime()));
        }
        return auditInfoBuilder.build();
    }

    public static Distribution getDistribution(Table table) {
        StorageDescriptor sd = table.getSd();
        Distribution distribution = Distributions.NONE;
        if (sd.getBucketCols() != null && !sd.getBucketCols().isEmpty()) {
            distribution = Distributions.hash((int)sd.getNumBuckets(), (Expression[])((Expression[])sd.getBucketCols().stream().map(NamedReference::field).toArray(Expression[]::new)));
        }
        return distribution;
    }

    public static SortOrder[] getSortOrders(Table table) {
        SortOrder[] sortOrders = SortOrders.NONE;
        StorageDescriptor sd = table.getSd();
        if (sd.getSortCols() != null && !sd.getSortCols().isEmpty()) {
            sortOrders = (SortOrder[])sd.getSortCols().stream().map(f -> SortOrders.of((Expression)NamedReference.field((String)f.getCol()), (SortDirection)(f.getOrder() == 1 ? SortDirection.ASCENDING : SortDirection.DESCENDING))).toArray(SortOrder[]::new);
        }
        return sortOrders;
    }

    public static Transform[] getPartitioning(Table table) {
        return (Transform[])table.getPartitionKeys().stream().map(p -> Transforms.identity((String)p.getName())).toArray(Transform[]::new);
    }

    public static Column[] getColumns(Table table) {
        StorageDescriptor sd = table.getSd();
        Set columnNames = sd.getCols().stream().map(FieldSchema::getName).collect(Collectors.toSet());
        return (Column[])Stream.concat(sd.getCols().stream().map(f -> HiveTableConverter.buildColumn(f.getName(), HiveDataTypeConverter.CONVERTER.toGravitino(f.getType()), f.getComment())), table.getPartitionKeys().stream().filter(p -> !columnNames.contains(p.getName())).map(p -> HiveTableConverter.buildColumn(p.getName(), HiveDataTypeConverter.CONVERTER.toGravitino(p.getType()), p.getComment()))).toArray(Column[]::new);
    }

    private static Column buildColumn(String name, Type type, String comment) {
        HiveColumn.Builder builder = (HiveColumn.Builder)((HiveColumn.Builder)((HiveColumn.Builder)HiveColumn.builder().withName(name)).withType(type)).withNullable(true);
        if (comment != null) {
            builder.withComment(comment);
        }
        return builder.build();
    }

    public static HivePartition fromHivePartition(HiveTable table, Partition partition) {
        Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"Table cannot be null");
        Preconditions.checkArgument((partition != null ? 1 : 0) != 0, (Object)"Partition cannot be null");
        List<String> partitionColumns = table.partitionFieldNames();
        String partitionName = FileUtils.makePartName(partitionColumns, (List)partition.getValues());
        return HivePartition.identity(partitionName, partition.getParameters());
    }

    public static Partition toHivePartition(String dbName, HiveTable table, HivePartition partition) {
        Preconditions.checkArgument((dbName != null ? 1 : 0) != 0, (Object)"Database name cannot be null");
        Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"Table cannot be null");
        Preconditions.checkArgument((partition != null ? 1 : 0) != 0, (Object)"Partition cannot be null");
        Partition hivePartition = new Partition();
        hivePartition.setDbName(dbName);
        hivePartition.setTableName(table.name());
        List<FieldSchema> partitionFields = table.partitionFieldNames().stream().map(fieldName -> HiveTableConverter.buildPartitionKeyField(fieldName, table)).collect(Collectors.toList());
        StorageDescriptor sd = HiveTableConverter.buildStorageDescriptor(table, partitionFields);
        sd.setLocation(null);
        hivePartition.setSd(sd);
        hivePartition.setParameters(partition.properties());
        List<String> values = HivePartition.extractPartitionValues(partition.name());
        hivePartition.setValues(values);
        return hivePartition;
    }
}

