/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.postgresql.operation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.catalog.jdbc.JdbcColumn;
import org.apache.gravitino.catalog.jdbc.JdbcTable;
import org.apache.gravitino.catalog.jdbc.config.JdbcConfig;
import org.apache.gravitino.catalog.jdbc.converter.JdbcColumnDefaultValueConverter;
import org.apache.gravitino.catalog.jdbc.converter.JdbcExceptionConverter;
import org.apache.gravitino.catalog.jdbc.converter.JdbcTypeConverter;
import org.apache.gravitino.catalog.jdbc.operation.DatabaseOperation;
import org.apache.gravitino.catalog.jdbc.operation.JdbcTableOperations;
import org.apache.gravitino.catalog.jdbc.operation.RequireDatabaseOperation;
import org.apache.gravitino.catalog.postgresql.operation.PostgreSqlSchemaOperations;
import org.apache.gravitino.exceptions.NoSuchColumnException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Distributions;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;

public class PostgreSqlTableOperations
extends JdbcTableOperations
implements RequireDatabaseOperation {
    public static final String PG_QUOTE = "\"";
    public static final String NEW_LINE = "\n";
    public static final String ALTER_TABLE = "ALTER TABLE ";
    public static final String ALTER_COLUMN = "ALTER COLUMN ";
    public static final String IS = " IS '";
    public static final String COLUMN_COMMENT = "COMMENT ON COLUMN ";
    public static final String TABLE_COMMENT = "COMMENT ON TABLE ";
    private static final String POSTGRESQL_NOT_SUPPORT_NESTED_COLUMN_MSG = "PostgreSQL does not support nested column names.";
    private String database;
    private PostgreSqlSchemaOperations schemaOperations;

    public void initialize(DataSource dataSource, JdbcExceptionConverter exceptionMapper, JdbcTypeConverter jdbcTypeConverter, JdbcColumnDefaultValueConverter jdbcColumnDefaultValueConverter, Map<String, String> conf) {
        super.initialize(dataSource, exceptionMapper, jdbcTypeConverter, jdbcColumnDefaultValueConverter, conf);
        this.database = new JdbcConfig(conf).getJdbcDatabase();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.database), (Object)"The `jdbc-database` configuration item is mandatory in PostgreSQL.");
    }

    public void setDatabaseOperation(DatabaseOperation databaseOperation) {
        this.schemaOperations = (PostgreSqlSchemaOperations)databaseOperation;
    }

    public List<String> listTables(String schemaName) throws NoSuchSchemaException {
        ArrayList arrayList;
        block17: {
            Connection connection = this.getConnection(schemaName);
            try {
                if (!this.schemaOperations.schemaExists(connection, schemaName)) {
                    throw new NoSuchSchemaException("No such schema: %s", new Object[]{schemaName});
                }
                ArrayList names = Lists.newArrayList();
                try (ResultSet tables = this.getTables(connection);){
                    while (tables.next()) {
                        if (!Objects.equals(tables.getString("TABLE_SCHEM"), schemaName)) continue;
                        names.add(tables.getString("TABLE_NAME"));
                    }
                }
                LOG.info("Finished listing tables size {} for database name {} ", (Object)names.size(), (Object)schemaName);
                arrayList = names;
                if (connection == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException se) {
                    throw this.exceptionMapper.toGravitinoException(se);
                }
            }
            connection.close();
        }
        return arrayList;
    }

    protected JdbcTable.Builder getTableBuilder(ResultSet tablesResult, String databaseName, String tableName) throws SQLException {
        boolean found = false;
        JdbcTable.Builder builder = null;
        while (tablesResult.next() && !found) {
            String tableNameInResult = tablesResult.getString("TABLE_NAME");
            String tableSchemaInResultLowerCase = tablesResult.getString("TABLE_SCHEM");
            if (!Objects.equals(tableNameInResult, tableName) || !Objects.equals(tableSchemaInResultLowerCase, databaseName)) continue;
            builder = this.getBasicJdbcTableInfo(tablesResult);
            found = true;
        }
        if (!found) {
            throw new NoSuchTableException("Table %s does not exist in %s.", new Object[]{tableName, databaseName});
        }
        return builder;
    }

    protected JdbcColumn.Builder getColumnBuilder(ResultSet columnsResult, String databaseName, String tableName) throws SQLException {
        JdbcColumn.Builder builder = null;
        if (Objects.equals(columnsResult.getString("TABLE_NAME"), tableName) && Objects.equals(columnsResult.getString("TABLE_SCHEM"), databaseName)) {
            builder = this.getBasicJdbcColumnInfo(columnsResult);
        }
        return builder;
    }

    protected String generateCreateTableSql(String tableName, JdbcColumn[] columns, String comment, Map<String, String> properties, Transform[] partitioning, Distribution distribution, Index[] indexes) {
        if (ArrayUtils.isNotEmpty((Object[])partitioning)) {
            throw new UnsupportedOperationException("Currently we do not support Partitioning in PostgreSQL");
        }
        Preconditions.checkArgument((boolean)Distributions.NONE.equals(distribution), (Object)"PostgreSQL does not support distribution");
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("CREATE TABLE ").append(PG_QUOTE).append(tableName).append(PG_QUOTE).append(" (").append(NEW_LINE);
        for (int i = 0; i < columns.length; ++i) {
            JdbcColumn column = columns[i];
            sqlBuilder.append("    ").append(PG_QUOTE).append(column.name()).append(PG_QUOTE);
            this.appendColumnDefinition(column, sqlBuilder);
            if (i >= columns.length - 1) continue;
            sqlBuilder.append(",").append(NEW_LINE);
        }
        PostgreSqlTableOperations.appendIndexesSql(indexes, sqlBuilder);
        sqlBuilder.append(NEW_LINE).append(")");
        if (MapUtils.isNotEmpty(properties)) {
            throw new IllegalArgumentException("Properties are not supported yet");
        }
        sqlBuilder.append(";");
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            sqlBuilder.append(NEW_LINE).append(TABLE_COMMENT).append(PG_QUOTE).append(tableName).append(PG_QUOTE).append(IS).append(comment).append("';");
        }
        Arrays.stream(columns).filter(jdbcColumn -> StringUtils.isNotEmpty((CharSequence)jdbcColumn.comment())).forEach(jdbcColumn -> sqlBuilder.append(NEW_LINE).append(COLUMN_COMMENT).append(PG_QUOTE).append(tableName).append(PG_QUOTE).append(".").append(PG_QUOTE).append(jdbcColumn.name()).append(PG_QUOTE).append(IS).append(jdbcColumn.comment()).append("';"));
        String result = sqlBuilder.toString();
        LOG.info("Generated create table:{} sql: {}", (Object)tableName, (Object)result);
        return result;
    }

    @VisibleForTesting
    static void appendIndexesSql(Index[] indexes, StringBuilder sqlBuilder) {
        block4: for (Index index : indexes) {
            String fieldStr = PostgreSqlTableOperations.getIndexFieldStr(index.fieldNames());
            sqlBuilder.append(",").append(NEW_LINE);
            switch (index.type()) {
                case PRIMARY_KEY: {
                    if (StringUtils.isNotEmpty((CharSequence)index.name())) {
                        sqlBuilder.append("CONSTRAINT ").append(PG_QUOTE).append(index.name()).append(PG_QUOTE);
                    }
                    sqlBuilder.append(" PRIMARY KEY (").append(fieldStr).append(")");
                    continue block4;
                }
                case UNIQUE_KEY: {
                    if (StringUtils.isNotEmpty((CharSequence)index.name())) {
                        sqlBuilder.append("CONSTRAINT ").append(PG_QUOTE).append(index.name()).append(PG_QUOTE);
                    }
                    sqlBuilder.append(" UNIQUE (").append(fieldStr).append(")");
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("PostgreSQL doesn't support index : " + String.valueOf(index.type()));
                }
            }
        }
    }

    protected static String getIndexFieldStr(String[][] fieldNames) {
        return Arrays.stream(fieldNames).map(colNames -> {
            if (((String[])colNames).length > 1) {
                throw new IllegalArgumentException("Index does not support complex fields in PostgreSQL");
            }
            return PG_QUOTE + colNames[0] + PG_QUOTE;
        }).collect(Collectors.joining(", "));
    }

    private void appendColumnDefinition(JdbcColumn column, StringBuilder sqlBuilder) {
        sqlBuilder.append(" ").append((String)this.typeConverter.fromGravitino(column.dataType())).append(" ");
        if (column.autoIncrement()) {
            if (!Types.allowAutoIncrement((Type)column.dataType())) {
                throw new IllegalArgumentException("Unsupported auto-increment , column: " + column.name() + ", type: " + String.valueOf(column.dataType()));
            }
            sqlBuilder.append("GENERATED BY DEFAULT AS IDENTITY ");
        }
        if (column.nullable()) {
            sqlBuilder.append("NULL ");
        } else {
            sqlBuilder.append("NOT NULL ");
        }
        if (!Column.DEFAULT_VALUE_NOT_SET.equals(column.defaultValue())) {
            sqlBuilder.append("DEFAULT ").append(this.columnDefaultValueConverter.fromGravitino(column.defaultValue())).append(" ");
        }
    }

    protected String generateRenameTableSql(String oldTableName, String newTableName) {
        return "ALTER TABLE \"" + oldTableName + "\" RENAME TO \"" + newTableName + PG_QUOTE;
    }

    protected String generateDropTableSql(String tableName) {
        return "DROP TABLE \"" + tableName + PG_QUOTE;
    }

    protected String generatePurgeTableSql(String tableName) {
        throw new UnsupportedOperationException("PostgreSQL does not support purge table in Gravitino, please use drop table");
    }

    protected String generateAlterTableSql(String schemaName, String tableName, TableChange ... changes) {
        JdbcTable lazyLoadTable = null;
        ArrayList<String> alterSql = new ArrayList<String>();
        for (TableChange change : changes) {
            if (change instanceof TableChange.UpdateComment) {
                lazyLoadTable = this.getOrCreateTable(schemaName, tableName, lazyLoadTable);
                alterSql.add(this.updateCommentDefinition((TableChange.UpdateComment)change, lazyLoadTable));
                continue;
            }
            if (change instanceof TableChange.SetProperty) {
                throw new IllegalArgumentException("Set property is not supported yet");
            }
            if (change instanceof TableChange.RemoveProperty) {
                throw new IllegalArgumentException("Remove property is not supported yet");
            }
            if (change instanceof TableChange.AddColumn) {
                TableChange.AddColumn addColumn = (TableChange.AddColumn)change;
                lazyLoadTable = this.getOrCreateTable(schemaName, tableName, lazyLoadTable);
                alterSql.addAll(this.addColumnFieldDefinition(addColumn, lazyLoadTable));
                continue;
            }
            if (change instanceof TableChange.RenameColumn) {
                TableChange.RenameColumn renameColumn = (TableChange.RenameColumn)change;
                alterSql.add(this.renameColumnFieldDefinition(renameColumn, tableName));
                continue;
            }
            if (change instanceof TableChange.UpdateColumnDefaultValue) {
                lazyLoadTable = this.getOrCreateTable(schemaName, tableName, lazyLoadTable);
                TableChange.UpdateColumnDefaultValue updateColumnDefaultValue = (TableChange.UpdateColumnDefaultValue)change;
                alterSql.add(this.updateColumnDefaultValueFieldDefinition(updateColumnDefaultValue, lazyLoadTable));
                continue;
            }
            if (change instanceof TableChange.UpdateColumnType) {
                lazyLoadTable = this.getOrCreateTable(schemaName, tableName, lazyLoadTable);
                TableChange.UpdateColumnType updateColumnType = (TableChange.UpdateColumnType)change;
                alterSql.add(this.updateColumnTypeFieldDefinition(updateColumnType, lazyLoadTable));
                continue;
            }
            if (change instanceof TableChange.UpdateColumnComment) {
                alterSql.add(this.updateColumnCommentFieldDefinition((TableChange.UpdateColumnComment)change, tableName));
                continue;
            }
            if (change instanceof TableChange.UpdateColumnPosition) {
                throw new IllegalArgumentException("PostgreSQL does not support column position.");
            }
            if (change instanceof TableChange.DeleteColumn) {
                TableChange.DeleteColumn deleteColumn = (TableChange.DeleteColumn)change;
                String deleteColSql = this.deleteColumnFieldDefinition(deleteColumn, lazyLoadTable = this.getOrCreateTable(schemaName, tableName, lazyLoadTable));
                if (!StringUtils.isNotEmpty((CharSequence)deleteColSql)) continue;
                alterSql.add(deleteColSql);
                continue;
            }
            if (change instanceof TableChange.UpdateColumnNullability) {
                TableChange.UpdateColumnNullability updateColumnNullability = (TableChange.UpdateColumnNullability)change;
                lazyLoadTable = this.getOrCreateTable(schemaName, tableName, lazyLoadTable);
                this.validateUpdateColumnNullable(updateColumnNullability, lazyLoadTable);
                alterSql.add(this.updateColumnNullabilityDefinition(updateColumnNullability, tableName));
                continue;
            }
            if (change instanceof TableChange.AddIndex) {
                alterSql.add(PostgreSqlTableOperations.addIndexDefinition(tableName, (TableChange.AddIndex)change));
                continue;
            }
            if (change instanceof TableChange.DeleteIndex) {
                alterSql.add(PostgreSqlTableOperations.deleteIndexDefinition(tableName, (TableChange.DeleteIndex)change));
                continue;
            }
            if (change instanceof TableChange.UpdateColumnAutoIncrement) {
                alterSql.add(PostgreSqlTableOperations.updateColumnAutoIncrementDefinition((TableChange.UpdateColumnAutoIncrement)change, tableName));
                continue;
            }
            throw new IllegalArgumentException("Unsupported table change type: " + change.getClass().getName());
        }
        if (alterSql.isEmpty()) {
            return "";
        }
        String result = String.join((CharSequence)NEW_LINE, alterSql);
        LOG.info("Generated alter table:{}.{} sql: {}", new Object[]{schemaName, tableName, result});
        return result;
    }

    @VisibleForTesting
    static String updateColumnAutoIncrementDefinition(TableChange.UpdateColumnAutoIncrement change, String tableName) {
        if (change.fieldName().length > 1) {
            throw new UnsupportedOperationException(POSTGRESQL_NOT_SUPPORT_NESTED_COLUMN_MSG);
        }
        String fieldName = change.fieldName()[0];
        String action = change.isAutoIncrement() ? "ADD GENERATED BY DEFAULT AS IDENTITY" : "DROP IDENTITY";
        return String.format("ALTER TABLE %s %s %s %s;", PG_QUOTE + tableName + PG_QUOTE, ALTER_COLUMN, PG_QUOTE + fieldName + PG_QUOTE, action);
    }

    @VisibleForTesting
    static String deleteIndexDefinition(String tableName, TableChange.DeleteIndex deleteIndex) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(ALTER_TABLE).append(PG_QUOTE).append(tableName).append(PG_QUOTE).append(" DROP CONSTRAINT ").append(PG_QUOTE).append(deleteIndex.getName()).append(PG_QUOTE).append(";\n");
        if (deleteIndex.isIfExists()) {
            sqlBuilder.append("DROP INDEX IF EXISTS ").append(PG_QUOTE).append(deleteIndex.getName()).append(PG_QUOTE).append(";");
        } else {
            sqlBuilder.append("DROP INDEX ").append(PG_QUOTE).append(deleteIndex.getName()).append(PG_QUOTE).append(";");
        }
        return sqlBuilder.toString();
    }

    @VisibleForTesting
    static String addIndexDefinition(String tableName, TableChange.AddIndex addIndex) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(ALTER_TABLE).append(PG_QUOTE).append(tableName).append(PG_QUOTE).append(" ADD CONSTRAINT ").append(PG_QUOTE).append(addIndex.getName()).append(PG_QUOTE);
        switch (addIndex.getType()) {
            case PRIMARY_KEY: {
                sqlBuilder.append(" PRIMARY KEY ");
                break;
            }
            case UNIQUE_KEY: {
                sqlBuilder.append(" UNIQUE ");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported index type: " + String.valueOf(addIndex.getType()));
            }
        }
        sqlBuilder.append("(").append(PostgreSqlTableOperations.getIndexFieldStr(addIndex.getFieldNames())).append(");");
        return sqlBuilder.toString();
    }

    private String updateColumnNullabilityDefinition(TableChange.UpdateColumnNullability updateColumnNullability, String tableName) {
        if (updateColumnNullability.fieldName().length > 1) {
            throw new UnsupportedOperationException(POSTGRESQL_NOT_SUPPORT_NESTED_COLUMN_MSG);
        }
        String col = updateColumnNullability.fieldName()[0];
        if (updateColumnNullability.nullable()) {
            return "ALTER TABLE \"" + tableName + "\" ALTER COLUMN \"" + col + "\" DROP NOT NULL;";
        }
        return "ALTER TABLE \"" + tableName + "\" ALTER COLUMN \"" + col + "\" SET NOT NULL;";
    }

    private String updateCommentDefinition(TableChange.UpdateComment updateComment, JdbcTable jdbcTable) {
        StringIdentifier identifier;
        String newComment = updateComment.getNewComment();
        if (null == StringIdentifier.fromComment((String)newComment) && StringUtils.isNotEmpty((CharSequence)jdbcTable.comment()) && null != (identifier = StringIdentifier.fromComment((String)jdbcTable.comment()))) {
            newComment = StringIdentifier.addToComment((StringIdentifier)identifier, (String)newComment);
        }
        return "COMMENT ON TABLE \"" + jdbcTable.name() + "\" IS '" + newComment + "';";
    }

    private String deleteColumnFieldDefinition(TableChange.DeleteColumn deleteColumn, JdbcTable table) {
        if (deleteColumn.fieldName().length > 1) {
            throw new UnsupportedOperationException(POSTGRESQL_NOT_SUPPORT_NESTED_COLUMN_MSG);
        }
        String col = deleteColumn.fieldName()[0];
        boolean colExists = Arrays.stream(table.columns()).anyMatch(s -> StringUtils.equals((CharSequence)col, (CharSequence)s.name()));
        if (!colExists) {
            if (BooleanUtils.isTrue((Boolean)deleteColumn.getIfExists())) {
                return "";
            }
            throw new IllegalArgumentException("Delete column does not exist: " + col);
        }
        return "ALTER TABLE \"" + table.name() + "\" DROP COLUMN \"" + deleteColumn.fieldName()[0] + "\";";
    }

    private String updateColumnDefaultValueFieldDefinition(TableChange.UpdateColumnDefaultValue updateColumnDefaultValue, JdbcTable jdbcTable) {
        if (updateColumnDefaultValue.fieldName().length > 1) {
            throw new UnsupportedOperationException(POSTGRESQL_NOT_SUPPORT_NESTED_COLUMN_MSG);
        }
        String col = updateColumnDefaultValue.fieldName()[0];
        JdbcColumn column = Arrays.stream(jdbcTable.columns()).filter(c -> c.name().equals(col)).findFirst().orElse(null);
        if (null == column) {
            throw new NoSuchColumnException("Column %s does not exist.", new Object[]{col});
        }
        StringBuilder sqlBuilder = new StringBuilder(ALTER_TABLE + jdbcTable.name());
        sqlBuilder.append(NEW_LINE).append(ALTER_COLUMN).append(PG_QUOTE).append(col).append(PG_QUOTE).append(" SET DEFAULT ").append(this.columnDefaultValueConverter.fromGravitino(updateColumnDefaultValue.getNewDefaultValue()));
        return sqlBuilder.append(";").toString();
    }

    private String updateColumnTypeFieldDefinition(TableChange.UpdateColumnType updateColumnType, JdbcTable jdbcTable) {
        if (updateColumnType.fieldName().length > 1) {
            throw new UnsupportedOperationException(POSTGRESQL_NOT_SUPPORT_NESTED_COLUMN_MSG);
        }
        String col = updateColumnType.fieldName()[0];
        JdbcColumn column = Arrays.stream(jdbcTable.columns()).filter(c -> c.name().equals(col)).findFirst().orElse(null);
        if (null == column) {
            throw new NoSuchColumnException("Column %s does not exist.", new Object[]{col});
        }
        StringBuilder sqlBuilder = new StringBuilder(ALTER_TABLE + jdbcTable.name());
        sqlBuilder.append(NEW_LINE).append(ALTER_COLUMN).append(PG_QUOTE).append(col).append(PG_QUOTE).append(" SET DATA TYPE ").append((String)this.typeConverter.fromGravitino(updateColumnType.getNewDataType()));
        if (!column.nullable()) {
            sqlBuilder.append(",\n").append(ALTER_COLUMN).append(PG_QUOTE).append(col).append(PG_QUOTE).append(" SET NOT NULL");
        }
        return sqlBuilder.append(";").toString();
    }

    private String renameColumnFieldDefinition(TableChange.RenameColumn renameColumn, String tableName) {
        if (renameColumn.fieldName().length > 1) {
            throw new UnsupportedOperationException(POSTGRESQL_NOT_SUPPORT_NESTED_COLUMN_MSG);
        }
        return ALTER_TABLE + tableName + " RENAME COLUMN \"" + renameColumn.fieldName()[0] + "\" TO \"" + renameColumn.getNewName() + "\";";
    }

    private List<String> addColumnFieldDefinition(TableChange.AddColumn addColumn, JdbcTable lazyLoadTable) {
        if (addColumn.fieldName().length > 1) {
            throw new UnsupportedOperationException(POSTGRESQL_NOT_SUPPORT_NESTED_COLUMN_MSG);
        }
        ArrayList<String> result = new ArrayList<String>();
        String col = addColumn.fieldName()[0];
        StringBuilder columnDefinition = new StringBuilder();
        columnDefinition.append(ALTER_TABLE).append(lazyLoadTable.name()).append(" ").append("ADD COLUMN ").append(PG_QUOTE).append(col).append(PG_QUOTE).append(" ").append((String)this.typeConverter.fromGravitino(addColumn.getDataType())).append(" ");
        if (addColumn.isAutoIncrement()) {
            if (!Types.allowAutoIncrement((Type)addColumn.getDataType())) {
                throw new IllegalArgumentException("Unsupported auto-increment , column: " + Arrays.toString(addColumn.getFieldName()) + ", type: " + String.valueOf(addColumn.getDataType()));
            }
            columnDefinition.append("GENERATED BY DEFAULT AS IDENTITY ");
        }
        if (!addColumn.isNullable()) {
            columnDefinition.append("NOT NULL ");
        }
        if (!Column.DEFAULT_VALUE_NOT_SET.equals(addColumn.getDefaultValue())) {
            columnDefinition.append("DEFAULT ").append(this.columnDefaultValueConverter.fromGravitino(addColumn.getDefaultValue())).append(" ");
        }
        if (!(addColumn.getPosition() instanceof TableChange.Default)) {
            throw new IllegalArgumentException("PostgreSQL does not support column position in Gravitino.");
        }
        result.add(columnDefinition.append(";").toString());
        if (StringUtils.isNotEmpty((CharSequence)addColumn.getComment())) {
            result.add("COMMENT ON COLUMN \"" + lazyLoadTable.name() + "\".\"" + col + "\" IS '" + addColumn.getComment() + "';");
        }
        return result;
    }

    private String updateColumnCommentFieldDefinition(TableChange.UpdateColumnComment updateColumnComment, String tableName) {
        String newComment = updateColumnComment.getNewComment();
        if (updateColumnComment.fieldName().length > 1) {
            throw new UnsupportedOperationException(POSTGRESQL_NOT_SUPPORT_NESTED_COLUMN_MSG);
        }
        String col = updateColumnComment.fieldName()[0];
        return "COMMENT ON COLUMN \"" + tableName + "\".\"" + col + "\" IS '" + newComment + "';";
    }

    protected ResultSet getIndexInfo(String schemaName, String tableName, DatabaseMetaData metaData) throws SQLException {
        return metaData.getIndexInfo(this.database, schemaName, tableName, false, false);
    }

    protected ResultSet getPrimaryKeys(String schemaName, String tableName, DatabaseMetaData metaData) throws SQLException {
        return metaData.getPrimaryKeys(this.database, schemaName, tableName);
    }

    protected Connection getConnection(String schema) throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setCatalog(this.database);
        connection.setSchema(schema);
        return connection;
    }

    protected ResultSet getTable(Connection connection, String schema, String tableName) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        return metaData.getTables(this.database, schema, tableName, null);
    }

    protected ResultSet getColumns(Connection connection, String schema, String tableName) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        return metaData.getColumns(this.database, schema, tableName, null);
    }

    public Integer calculateDatetimePrecision(String typeName, int columnSize, int scale) {
        String upperTypeName;
        switch (upperTypeName = typeName.toUpperCase()) {
            case "TIME": 
            case "TIMETZ": 
            case "TIMESTAMP": 
            case "TIMESTAMPTZ": {
                return Math.max(scale, 0);
            }
        }
        return null;
    }
}

